% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_skew_and_kurtosis.R
\name{ci_skewness}
\alias{ci_skewness}
\title{CI for the Skewness}
\usage{
ci_skewness(
  x,
  probs = c(0.025, 0.975),
  type = "bootstrap",
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default c(0.025, 0.975).}

\item{type}{Type of CI. Currently not used as the only type is \code{"bootstrap"}.}

\item{boot_type}{Type of bootstrap CI ("bca", "perc", "norm", "basic").}

\item{R}{The number of bootstrap resamples.}

\item{seed}{An integer random seed.}

\item{...}{Further arguments passed to \code{boot::boot()}.}
}
\value{
An object of class "cint" containing these components:
\itemize{
\item \code{parameter}: Parameter specification.
\item \code{interval}: CI for the parameter.
\item \code{estimate}: Parameter estimate.
\item \code{probs}: Lower and upper probabilities.
\item \code{type}: Type of interval.
\item \code{info}: Additional description.
}
}
\description{
This function calculates bootstrap CIs for the population skewness.
By default, bootstrap type "bca" is used.
}
\examples{
x <- 1:20
ci_skewness(x, R = 999)  # Use larger R
}
\seealso{
\code{\link{kurtosis}}
}
