% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{xval}
\alias{xval}
\title{Cross-validate boosted contrast tree boosted with (new) data}
\usage{
xval(
  mdl,
  x,
  y,
  z,
  num = length(mdl$tree),
  del = 10,
  span = 0.15,
  ylab = "Average  Discrepancy",
  doplot = "first",
  doprint = FALSE,
  col = "red"
)
}
\arguments{
\item{mdl}{model output from modtrast()}

\item{x}{data predictor variables is same format as input to modtrast}

\item{y}{data y values is same format as input to modtrast}

\item{z}{data z values is same format as input to modtrast}

\item{num}{number of trees used to compute model values}

\item{del}{plot discrepancy value computed every del-th iteration (tree)}

\item{span}{running median smoother span (\code{doplot=TRUE}, only)}

\item{ylab}{graphical parameter (`doplot="first", only)}

\item{doplot}{logical flag. doplot="first" implies start new display. doplot="next" implies super impose plot on existing display. doplot="none" implies no plot displayed.}

\item{doprint}{logical flag \code{TRUE/FALSE} implies do/don't print progress while executing, default \code{FALSE}}

\item{col}{color of plotted curve}
}
\value{
a named list of two items: \code{ntree} the iteration numbers, and \code{error} the corresponding discrepancy values
}
\description{
Cross-validate boosted contrast tree boosted with (new) data
}
\seealso{
\code{\link[=contrast]{contrast()}}
}
