% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{cs_filter_count}
\alias{cs_filter_count}
\title{Remove Negative Counts}
\usage{
cs_filter_count(.data, var)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{the name of the column}
}
\value{
A subset object with rows containing \code{-1} removed
}
\description{
Removes the row that contains \code{-1} in a specified column, indicating that the
    charge described in that observation has either been deemed unfounded or has been
    up-coded. For example, a victim of an aggravated assault dies, and the charge is changed
    to homicide.
}
\examples{
# load example data
testData <- january2018

# subset data to remove negative counts
testData <- cs_filter_count(testData, var = Count)

}
