% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{cooks.distance.zlm}
\alias{cooks.distance.zlm}
\title{Cook's Distance for Complex Linear Models}
\usage{
\method{cooks.distance}{zlm}(model, lever = zhatvalues(model), ...)
}
\arguments{
\item{model}{An object of class "lm" or "rlm". Can be complex or numeric.}

\item{lever}{A list of leverage scores with the same length as \code{model$residuals}. By default \link{zhatvalues} is called on \code{model}.}

\item{...}{Other parameters. Only used if \code{model} is numeric; in which case they are passed to \code{stats::cooks.distance}.}
}
\value{
A numeric vector. The elements are the Cook's distances of each data point in \code{model}.
}
\description{
Calculates the Cook's distances (technically a divergence, i.e. distance squared) of a complex linear model.
These serve as a measurement of how much each input data point had on the model.
}
\details{
Consider a linear model relating a response vector \code{y} to a predictor vector \code{x}, both of length \code{n}. Using the model and predictor vector we can
calculate a vector of predicted values \code{yh}. \code{y} and \code{yh} are points in a \code{n} dimensional output space. If we drop the \code{i}-th element of \code{x} and \code{y}, then fit another
model using the "dropped \code{i}" vectors, we can get another point in output space, \code{yhi}. The squared Euclidean distance between \code{yh} and \code{yhi}, divided by the
rank of the model times its mean squared error, is the \code{i}-th Cook's distance.\cr
\deqn{D_i = (yh - yhi)^\dagger (yh - yhi) / p s^2}\cr
A more elegent way to calculate it, which this function uses, is with the influence scores, \code{hii}.\cr
\deqn{D_i = |r_i|^2 / p s^2 hii / (1 - hii)}\cr
Where \code{r_i} is the \code{i}-th residual.
}
\note{
This is a simpler function than \link[stats:influence.measures]{stats::cooks.distance}, and does not understand any additional parameters not listed in this entry.
}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
xx <- complex(real= rnorm(n), imaginary= rnorm(n))
tframe <- data.frame(x = xx, y= slop*xx + interc + e)
fit <- lm(y ~ x, data = tframe, weights = rep(1,n))
cooks.distance(fit)
}
\references{
R. D. Cook, Influential Observations in Linear Regression, Journal of the American Statistical Association 74, 169 (1979).
}
\seealso{
\link[stats:influence.measures]{stats::cooks.distance}, \link{zhatvalues}
}
