% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnsComparison.R
\name{compare_df}
\alias{compare_df}
\title{Compare Two dataframes}
\usage{
compare_df(
  df_new,
  df_old,
  group_col,
  exclude = NULL,
  tolerance = 0,
  tolerance_type = "ratio",
  stop_on_error = TRUE,
  keep_unchanged_rows = FALSE,
  keep_unchanged_cols = TRUE,
  change_markers = c("+", "-", "="),
  round_output_to = 3
)
}
\arguments{
\item{df_new}{The data frame for which any changes will be shown as an addition (green)}

\item{df_old}{The data frame for which any changes will be shown as a removal (red)}

\item{group_col}{A character vector of a string of character vector showing the columns
by which to group_by.}

\item{exclude}{The columns which should be excluded from the comparison}

\item{tolerance}{The amount in fraction to which changes are ignored while showing the
visual representation. By default, the value is 0 and any change in the value of variables
is shown off. Doesn't apply to categorical variables.}

\item{tolerance_type}{Defaults to 'ratio'. The type of comparison for numeric values, can be 'ratio' or 'difference'}

\item{stop_on_error}{Whether to stop on acceptable errors on not}

\item{keep_unchanged_rows}{whether to preserve unchanged values or not. Defaults to \code{FALSE}}

\item{keep_unchanged_cols}{whether to preserve unchanged values or not. Defaults to \code{TRUE}}

\item{change_markers}{what the different change_type nomenclature should be eg: c("new", "old", "unchanged").}

\item{round_output_to}{Number of digits to round the output to. Defaults to 3.}
}
\description{
Do a git style comparison between two data frames of similar columnar structure
}
