% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{v}
\alias{v}
\title{Combine unquoted values}
\usage{
v(...)
}
\arguments{
\item{...}{One or more unquoted values.}
}
\value{
A vector of quoted values.
}
\description{
A function to quote and combine unquoted values.
The function will return a vector of quoted values.  This function
allows you to use non-standard evaluation for any parameter
that accepts a string or vector of strings.
}
\examples{
# Combine unquoted values
v(var1, var2, var3)
# [1] "var1" "var2" "var3"

# Data frame subset
dat <- mtcars[1:5, v(mpg, cyl, disp)]
dat
#                    mpg cyl disp
# Mazda RX4         21.0   6  160
# Mazda RX4 Wag     21.0   6  160
# Datsun 710        22.8   4  108
# Hornet 4 Drive    21.4   6  258
# Hornet Sportabout 18.7   8  360

# Data frame sort
dat2 <- sort(dat, by = v(cyl, mpg))
dat2
#                    mpg cyl disp
# Datsun 710        22.8   4  108
# Mazda RX4         21.0   6  160
# Mazda RX4 Wag     21.0   6  160
# Hornet 4 Drive    21.4   6  258
# Hornet Sportabout 18.7   8  360
}
