% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcATHB2.r
\name{calcATHBpmv}
\alias{calcATHBpmv}
\title{PMV based on Adaptive Thermal Heat Balance Framework}
\usage{
calcATHBpmv(trm, ta, tr, vel, rh, met)
}
\arguments{
\item{trm}{- Running mean outdoor temperature in [degree C]}

\item{ta}{- a numeric value presenting air temperature in [degree C]}

\item{tr}{- a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{- a numeric value presenting air velocity in [m/s]}

\item{rh}{- a numeric value presenting relative humidity [\%]}

\item{met}{- a numeric value presenting metabolic rate in [met]}
}
\value{
\code{calcATHBpmv} PMV value adapted through the ATHB appoach
}
\description{
\code{calcATHBpmv} calculates the PMV based on adaptive thermal heat balance framework

based on the newest version (2022)
}
\details{
aliases athb ATHB
}
\examples{
calcATHBpmv(20, 25, 25, .1, 50, 1.1)
}
\references{
Schweiker & Wagner (2015) <doi:10.1016/j.buildenv.2015.08.018>
Schweiker (2022) <doi:10.1111/ina.13018>
}
\seealso{
see also \code{\link{calcComfInd}}, \code{link{calcATHBpts}}, \code{link{calcATHBset}},

\code{link{calcATHBpmv2015}}
}
\author{
Marcel Schweiker
}
