% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_sp.R
\name{se_sp}
\alias{se_sp}
\title{Compute sensitivity and specificity of each combination}
\usage{
se_sp(data, combinations_table)
}
\arguments{
\item{data}{a data.frame returned by load_data().}

\item{combinations_table}{a data.frame containing how many samples of each class are "positive" for each combination (returned by combi()).}
}
\value{
data.frame with SE, SP and number of composing markers for each combination.
}
\description{
A function to compute sensitivity and specificity of each combination for each class.
}
\details{
This function calculate SE and SP for each combination. The SE of a given combination (capability to find real positives/cases) corresponds to the SE of the case class, while its SP (capability to exclude real negatives/controls) corresponds to the SP of the control class.
}
\examples{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)

combs <- combi(data= demo_data, signalthr=450, combithr=1)  # compute combinations


# To compute sensitivity and specificity of each combination

combs_SE_SP <- se_sp(data=demo_data, combinations_table=combs)
}
