% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_noise.R
\name{raw_estim}
\alias{raw_estim}
\title{Estimate Mean, SD, and Autocorrelation of Sample Noise.}
\usage{
raw_estim(noise)
}
\arguments{
\item{noise}{The vector of random numbers.}
}
\value{
A labeled vector with the sample mean, sample SD, and sample
  autocorrelation.
}
\description{
This function estimates the temporal autocorrelation of a vector of random
numbers, as well as the sample mean and standard deviation. Try feeding it the output of \code{\link{raw_noise}}.
}
\examples{
rednoise <- raw_noise(timesteps = 30, mu = 0.5, sigma = 0.2, phi = 0.3)
raw_estim(rednoise)
}
