% File responsivityMetrics.Rd
\encoding{UTF-8}

\name{responsivityMetrics}
\title{Compute Metrics for a Light Responder (e.g. a camera) or a Material Responder (e.g. a scanner)}
\alias{responsivityMetrics}
\alias{responsivityMetrics.colorSpec}

\description{
This function computes a few technical metrics regarding some
geometric objects related to a responder:
the spherical chromaticity polygon, cone, convex cone, and color-solid.

Currently the function only works if the number of spectra in \code{x} is 3 (e.g. RGB or XYZ).
In this case the rows of \code{as.matrix(x)} (after weighting by step size)
are called the \emph{generators}; they are vectors in \eqn{R^3} 
and we require that they are all in some open linear halfspace (unless a generator is 0).
The 0-based rays through the generators intersect a plane inside the halfspace to form the vertices
of the \emph{chromaticity polygon} \eqn{P}.
The 0-based rays through points of the interior of \eqn{P} form a cone,
and the convex hull of this cone is a convex cone.
The central projection of \eqn{P} onto the unit sphere is the \emph{spherical chromaticity polygon} \eqn{P_S}.
If \code{type} is \code{'responsivity.material'}, then \code{x} has an
\emph{object-color solid} or \emph{Rösch Farbkörper},
which is a zonohedron \eqn{Z}.
See \cite{Centore} and vignette
\href{../doc/convexity.pdf}{\bold{Convexity and Transitions}}
for details.
\cr
Some simplification of the generators is performed during pre-processing.
Generators that are 0 (in all channels) are removed,
and a group of generators that are all positive multiples of each other is replaced by their sum.
The 3-vectors are called the \emph{condensed generators}.
These simplifications do not change any of the geometric objects defined above.
}


\usage{
\S3method{responsivityMetrics}{colorSpec}( x )

}

\arguments{
\item{x}{a \bold{colorSpec} object with \code{type}
equal to \code{'responsivity.light'} or \code{'responsivity.material'}, and 3 spectra}
}


\value{
\code{responsivityMetrics()} returns a list with these items:

\item{generators}{
a pair of integers, the 1st is the number of original generators,
and the 2nd is the number of condensed generators
}

\item{zeros}{vector of wavelengths at which the responsivity is 0 (in all 3 channels)}

\item{multiples}{a list of vectors of wavelengths; the responsivities in each vector (group) are positive multiples of each other}

\item{salient}{a logical where TRUE means that there is some open linear halfspace that contains all the non-zero generators.  If all the responsivities are non-negative, which is the usual case, then \code{salient=TRUE}.}

\item{normal}{If \code{salient=TRUE}, then the inward pointing unit normal for the previous halfspace.
Otherwise, \code{normal=NA}.}

If \code{salient=TRUE}, then the list also contains:

\item{concavities}{a \code{data.frame} with 2 columns: \code{wavelength} and \code{extangle},
where \code{extangle} is the external angle at the wavelength (for the spherical chromaticity polygon \eqn{P_S}), 
and is negative.
A negative angle means that \eqn{P_S} is concave at that vertex.}

\item{coneangle}{the solid angle of the cone generated by the generators.
This is identical to the area of the spherical chromaticity polygon, with concavities preserved.
}
  
\item{cxconeangle}{the solid angle of the convex cone generated by the generators, with no concavities.
This is identical to the area of the convex hull of the spherical chromaticity polygon.
If all responsivities are non-negative, which is the usual case, then this solid angle is less than
the solid angle of an octant, which is \eqn{\pi/2}.}
    
If the type of x is \code{'responsivity.material'} then the list also contains:    
  
\item{area}{the surface area of the object-color solid of \code{x}}
  
\item{volume}{the volume of the object-color solid of \code{x}}

In case of global error, the function returns \code{NULL}.
}


\note{
To determine the value of \code{salient}, the package \bold{quadprog} might be required.
}

\seealso{
\code{\link{type}},
vignette \href{../doc/convexity.pdf}{\bold{Convexity and Transitions}}
}

\references{
Centore, Paul.
\emph{A zonohedral approach to optimal colours}.
\bold{Color Research & Application}.
Vol. 38.
No. 2.
pp. 110-119.
April 2013.

}





\keyword{colorSpec}
