% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coi5p.r
\name{frame}
\alias{frame}
\alias{frame.coi5p}
\title{Take a coi5p sequence and place it in reading frame.}
\usage{
frame(x, ...)

\method{frame}{coi5p}(x, ...)
}
\arguments{
\item{x}{A coi5p class object.}

\item{...}{Additional arguments to be passed between methods.}
}
\value{
An object of class \code{"coi5p"}
}
\description{
Take a coi5p sequence and place it in reading frame.
}
\details{
This function compares the raw sequence against the nucleotide PHMM using the Viterbi algorithm. The path of hidden states
produced by the comparison is used to establish the reading frame of the sequence. If leading insert states are present, the
front of the sequence is trimmed to the first continuous set of match states and the sequence is re-compared to the
nucleotide PHMM. This is done because spurious or outlier matches early in the sequence can lead to incorrect establishment
of the reading frame. Realigning only the truncated version of the sequence to the PHMM improves correct reading frame establishment,
although this can also result in the loss of a few bp of true barcode sequence on the peripherals of the sequence.
}
\examples{
#previously run function:
dat = coi5p(example_nt_string)

dat = frame(dat)

#additional components in output coi5p object:
dat$framed
}
\seealso{
\code{\link{coi5p}}
}
