% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractPath.r
\name{extractPath}
\alias{extractPath}
\alias{extractPath.glmnet}
\alias{extractPath.cv.glmnet}
\title{extractPath}
\usage{
extractPath(model, ...)

\method{extractPath}{glmnet}(model, intercept = FALSE, ...)

\method{extractPath}{cv.glmnet}(model, ...)
}
\arguments{
\item{model}{A \code{\link[glmnet]{glmnet}} model}

\item{\dots}{Further arguments}

\item{intercept}{If \code{FALSE} (the default), no intercept will be provided}
}
\value{
A \code{link[tibble]{tibble}} holding the coefficients for various lambdas
}
\description{
Extracts the coefficient path of the elastic net
}
\details{
This is a replacement plot for visualizing the coefficient path resulting from the elastic net.
}
\examples{

library(glmnet)
data(diamonds, package='ggplot2')
diaX <- useful::build.x(price ~ carat + cut + x - 1, data=diamonds, contrasts = TRUE)
diaY <- useful::build.y(price ~ carat + cut + x - 1, data=diamonds)
modG1 <- glmnet(x=diaX, y=diaY)
extractPath(modG1)

modG2 <- cv.glmnet(x=diaX, y=diaY, nfolds=5)
extractPath(modG2)

}
\author{
Jared P. Lander
}
