## **************************************************************************
##
##    (c) 2018-2023 Guillaume Guénard
##        Department de sciences biologiques,
##        Université de Montréal
##        Montreal, QC, Canada
##
##    **St. Marguerite river salmon data set**
##
##    This file is part of codep
##
##    codep is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    codep is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with codep. If not, see <https://www.gnu.org/licenses/>.
##
##    Data set documentation generation file
##
## **************************************************************************
##
#' The St. Marguerite River Altantic Salmon Parr Transect
#' 
#' Juvenile Atlantic salmon (parr) density in a 1520m transect of the St.
#' Marguerite River, Québec, Canada.
#' 
#' @docType data
#' 
#' @name salmon
#' 
#' @usage data(salmon)
#' 
#' @format A 76 rows by  5 columns \code{\link{data.frame}}.
#' 
#' @details Contains (1) the 76 sampling site positions along a 1520 m river
#' segment beginning at a location called `Bardsville` (Lat: 48°23'01.59'' N ;
#' Long: 70°12'10.05'' W), (2) the number of parr (young salmon, ages I+ and
#' II+) observed at the sampling sites, (3) the mean water depths (m), (4) the
#' mean current velocity (m/s), and (5) the mean substrate size (mm). Sampling
#' took place on July 7, 2002, in the 76 sites, each 20 m long. The `Bardsville`
#' river segment is located in the upper portion of Sainte-Marguerite River,
#' Quebec, Canada.
#' 
#' @source Daniel Boisclair, Département de sciences biologiques, Université de
#' Montréal, Montréal, Québec, Canada.
#' 
#' @references
#' Guénard, G., Legendre, P., Boisclair, D., and Bilodeau, M. 2010. Multiscale
#' codependence analysis: an integrated approach to analyse relationships across
#' scales. Ecology 91: 2952-2964
#' 
#' @seealso
#' Bouchard, J. and Boisclair, D. 2008. The relative importance of local,
#' lateral, and longitudinal variables on the development of habitat quality
#' models for a river. Can. J. Fish. Aquat. Sci. 65: 61-73
#' 
#' @examples
#' data(salmon)
#' summary(salmon)
#' 
#' @keywords salmon
#' 
NULL
#' 
