
# Generation of Code Names for Organizations, People, Projects, and Whatever Else

[![](https://www.r-pkg.org/badges/version/codename?color=green)](https://cran.r-project.org/package=codename)
[![](http://cranlogs.r-pkg.org/badges/grand-total/codename?color=green)](https://cran.r-project.org/package=codename)
[![](http://cranlogs.r-pkg.org/badges/last-month/codename?color=green)](https://cran.r-project.org/package=codename)
[![](http://cranlogs.r-pkg.org/badges/last-week/codename?color=green)](https://cran.r-project.org/package=codename)

`codename` allows for users to create short, pithy code names for their
organizations, their work projects, themselves, other people, or
whatever else. The core of this package is the eponymous `codename()`
function, which allows the user to create various types of code names.
The code names returned from this function, by in large, are a two-word
character vector of an attribute and an object. Right now, options
include “any” (which is default and incorporates a battery of adjectives
and nouns), “gods” (in which the object is the name of a deity or saint
from some religion), “ubuntu” (in which the code name is alliterative
but the object is always an animal), and “wu-tang” (in which the code
name is derived from the classic Wu-Tang Name Generator). `codename()`
also features the ability to use reproducible seeds, including character
seeds, for maximum transparency and reproducibility.

# Installation

You will ideally soon be able to install this on CRAN, as follows:

``` r
install.packages("codename")
```

Until then, you can install the development version of this package
through the `devtools` package.

``` r
devtools::install_github("svmiller/codename")
```

# Usage

There isn’t much to belabor here and usage should be self-explanatory.
Here is some sample output.

``` r
library(codename)

# Generate console message about package version.
# Successive updates may break the expected output of a reproducible seed.
# This just adds some layer of transparency/clarity.
codename_message()
#> code name generated by {codename} v.0.2.0

# defaults to any
codename()
#> [1] "hot colon"
codename()
#> [1] "automatic cafe"
codename()
#> [1] "pumpkin pricing"
codename()
#> [1] "aqua marine weed"
codename(seed = 8675309)
#> [1] "content wilderness"
codename(seed = "My Project Name: The Subtitle of It Too")
#> [1] "grateful accusation"

codename(type = "gods")
#> [1] "silver ahura mazda"
codename(type = "gods")
#> [1] "grand anath"
codename(type = "gods")
#> [1] "faded blue olorum"
codename(type = "gods", seed = 8675309)
#> [1] "creamy sterculius"

codename(type = "ubuntu")
#> [1] "mint moth"
codename(type = "ubuntu")
#> [1] "trained tahr"
codename(type = "ubuntu")
#> [1] "yellowgreen yak"
codename(type = "ubuntu", seed = 8675309)
#> [1] "leaf landfowl"
codename(type = "ubuntu", seed = "My Ubuntu Release")
#> [1] "lovely lungfish"

codename(type = "wu-tang")
#> [1] "Quiet Destroyer"
codename(type = "wu-tang")
#> [1] "Crazy Bandit"
codename(type = "wu-tang")
#> [1] "Mighty Conqueror"
codename(type = "wu-tang", seed = "Steven V. Miller")
#> [1] "Foolish Bandit"

variety_pack(seed = "A Reproducible Character Seed")
#> [1] "tealish green protocol"
#> [1] "superb lumaluma"
#> [1] "glum gazelle"
#> [1] "E-ratic Leader"
```

# Hall of Fame Entries

This is an incomplete and running list of some of my favorite returns
from this function. Because most of the sample output on the README is a
one-off return, these are prone to disappear every time the README is
updated. No matter, I want to preserve some of these, for posterity.

-   electric lime agenda
-   second-hand shovel
-   reckless azimuth
-   x-pert anesthesiology
