% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_metadata.R
\name{list_to_dict}
\alias{list_to_dict}
\alias{dict_to_list}
\title{Go from a named list to a key-value data frame or data dictionary and back}
\usage{
list_to_dict(named_list)

dict_to_list(dict)
}
\arguments{
\item{named_list}{a named list with one element each (names being variable names, elements being labels)}

\item{dict}{a data frame with the variable names in the first and the labels in the second column. If they are named variable and label, they can also be in a different order.}
}
\description{
Sometimes, you'll want to have variable labels in a data.frame, sometimes
you'll have imported an existing data dictionary and will need to turn it
into a list before setting \code{\link[labelled:var_label]{labelled::var_label()}}.
}
\examples{
data('bfi')
labels <- var_label(bfi)
head(labels, 2)
dict <- list_to_dict(labels)
head(dict, 2)
head(dict_to_list(list_to_dict(labels)), 2)



}
