% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_metadata.R
\name{aggregate_and_document_scale}
\alias{aggregate_and_document_scale}
\title{Aggregate variables and remember which variables this were}
\usage{
aggregate_and_document_scale(items, fun = rowMeans, stem = NULL)
}
\arguments{
\item{items}{data.frame of the items that should be aggregated}

\item{fun}{aggregation function, defaults to rowMeans with na.rm = FALSE}

\item{stem}{common stem for the variables, specify if it should not be auto-detected
as the longest common stem of the variable names}
}
\description{
The resulting variables will have the attribute \code{scale_item_names} containing
the basis for aggregation. Its \code{label} attribute will refer to the common stem of the
aggregated variable names (if any), the number of variables, and the
aggregation function.
}
\examples{
testdf <- data.frame(bfi_neuro_1 = rnorm(20), bfi_neuro_2 = rnorm(20),
                    bfi_neuro_3R = rnorm(20), age = rpois(20, 30))
item_names <- c('bfi_neuro_1', 'bfi_neuro_2', 'bfi_neuro_3R')
testdf$bfi_neuro <- aggregate_and_document_scale(testdf[, item_names])
testdf$bfi_neuro
}
