% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{sbp_basis}
\alias{sbp_basis}
\title{Isometric log-ratio basis based on Balances
Build an \code{\link{ilr_basis}} using a sequential binary partition or
a generic coordinate system based on balances.}
\usage{
sbp_basis(..., data = NULL, silent = F)
}
\arguments{
\item{...}{balances to consider}

\item{data}{composition from where name parts are extracted}

\item{silent}{inform about orthgonality}
}
\value{
matrix
}
\description{
Isometric log-ratio basis based on Balances
Build an \code{\link{ilr_basis}} using a sequential binary partition or
a generic coordinate system based on balances.
}
\examples{
X = data.frame(a=1:2, b=2:3, c=4:5, d=5:6, e=10:11, f=100:101, g=1:2)
sbp_basis(b1 = a~b+c+d+e+f+g,
          b2 = b~c+d+e+f+g,
          b3 = c~d+e+f+g,
          b4 = d~e+f+g,
          b5 = e~f+g,
          b6 = f~g, data = X)
sbp_basis(b1 = a~b,
         b2 = b1~c,
         b3 = b2~d,
         b4 = b3~e,
         b5 = b4~f,
         b6 = b5~g, data = X)
# A non-orthogonal basis can also be calculated.
sbp_basis(b1 = a+b+c~e+f+g,
          b2 = d~a+b+c,
          b3 = d~e+g,
          b4 = a~e+b,
          b5 = b~f,
          b6 = c~g, data = X)
}
