% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/segsites.R
\name{create_segsites}
\alias{create_segsites}
\alias{get_positions}
\alias{get_snps}
\alias{get_trio_locus}
\alias{is_segsites}
\alias{segsites}
\alias{set_positions}
\alias{set_trio_locus}
\title{Segregating Sites}
\usage{
create_segsites(snps, positions, trio_locus = numeric(0), check = TRUE)

get_snps(segsites)

get_positions(segsites)

set_positions(segsites, positions)

get_trio_locus(segsites)

set_trio_locus(segsites, trio_locus)

is_segsites(segsites)
}
\arguments{
\item{snps}{The SNP Matrix (see Details).}

\item{positions}{A numeric vector indicating the relative positions of each
SNP on the locus (see Details).}

\item{trio_locus}{If the locus consists of a locus trio (see Details).}

\item{check}{Whether non-segregating sites are remove from the segregating
sites (\code{TRUE}) or not (\code{FALSE}).}

\item{segsites}{The segregating sites object}
}
\description{
This functions allow the creation and modification of segregating sites
objects, which are one of the most basic intermediary statistics that is
calculated in coala. Segregating sites are primarily SNP matrix that
contains all SNPs for one locus, with some additional information attached.
The parts of the S3 class are detailed below.
}
\details{
A segregating sites object contains all SNPs for one genetic locus. Each
object consists of tree parts: A SNP matrix, a vector of SNP positons and
a vector that states which transcript a SNP belong to, if the locus
consists of multiple transscripts ('locus trio').

\itemize{
  \item{In the \strong{SNP} matrix, each row represents a haplotype and each
        column represents a SNP. An entry is either \code{1} if the
        haplotype carries the derived allele for the SNP, or \code{0} if it
        carries the ancestral one.}
  \item{In the \strong{positions} vector, each entry gives the relative
        position of SNP in the corresponding column of the SNP matrix.}
  \item{The \strong{trio_locus} vector contains the trio locus each SNP
        belongs to. Entry of \code{-1},\code{0}, \code{1} represent the
        left, middle, and right locus, respectively. For normal loci,
        this just consists of \code{0}'s}
}
}
\section{Functions}{
\itemize{
\item \code{get_snps}: Returns the SNP matrix from a segregating sites
object.

\item \code{get_positions}: Returns the SNP's positions from a segregating
sites  object.

\item \code{set_positions}: Sets the SNP's positions in a segregating
sites object.

\item \code{get_trio_locus}: Returns the trio locus positions from a
segregating sites  object.

\item \code{set_trio_locus}: Sets the trio locus in a segregating sites
object.

\item \code{is_segsites}: Checks whether an object is a segsites object.
}}
\author{
Paul Staab
}

