% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seltime.R
\name{seltime}
\alias{seltime}
\title{Extract specific timestep.}
\usage{
seltime(
  var,
  hour_min = c("00:00:00"),
  infile,
  outfile,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{var}{Name of NetCDF variable (character).}

\item{hour_min}{Times, which should be selected, in form of a vector of
character values in the form of 'HH:MM:SS' (e.g. c('12:00:00') (character).}

\item{infile}{Filename of input NetCDF file. This may include the directory
(character).}

\item{outfile}{Filename of output NetCDF file. This may include the directory
(character).}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}
}
\value{
A NetCDF file including a time series of the selected times is written.
}
\description{
This function selects a given list of times from a time series.
}
\examples{
## Create an example NetCDF file with a similar structure as used by CM
## SAF. The file is created with the ncdf4 package.  Alternatively
## example data can be freely downloaded here: <https://wui.cmsaf.eu/>

library(ncdf4)

## create some (non-realistic) example data

lon <- seq(5, 15, 0.5)
lat <- seq(45, 55, 0.5)
time <- seq(ISOdate(2000, 1, 1), ISOdate(2000, 1, 6), "hours")
origin <- as.Date("1983-01-01 00:00:00")
time <- as.numeric(difftime(time, origin, units = "hour"))
data <- array(250:350, dim = c(21, 21, 121))

## create example NetCDF

x <- ncdim_def(name = "lon", units = "degrees_east", vals = lon)
y <- ncdim_def(name = "lat", units = "degrees_north", vals = lat)
t <- ncdim_def(name = "time", units = "hours since 1983-01-01 00:00:00",
 vals = time, unlim = TRUE)
var1 <- ncvar_def("SIS", "W m-2", list(x, y, t), -1, prec = "short")
vars <- list(var1)
ncnew <- nc_create(file.path(tempdir(),"CMSAF_example_file.nc"), vars)
ncvar_put(ncnew, var1, data)
ncatt_put(ncnew, "lon", "standard_name", "longitude", prec = "text")
ncatt_put(ncnew, "lat", "standard_name", "latitude", prec = "text")
nc_close(ncnew)

## Select all 12:00 and 21:00 values of the example CM SAF NetCDF file
## and write the output to a new file.
seltime(var = "SIS", hour_min = c("12:00:00", "21:00:00"), 
 infile = file.path(tempdir(),"CMSAF_example_file.nc"), 
 outfile = file.path(tempdir(),"CMSAF_example_file_seltime.nc"))

unlink(c(file.path(tempdir(),"CMSAF_example_file.nc"), 
 file.path(tempdir(),"CMSAF_example_file_seltime.nc")))
}
\seealso{
Other selection and removal functions: 
\code{\link{extract.level}()},
\code{\link{extract.period}()},
\code{\link{sellonlatbox}()},
\code{\link{selmon}()},
\code{\link{selperiod}()},
\code{\link{selpoint.multi}()},
\code{\link{selpoint}()},
\code{\link{selyear}()}
}
\concept{selection and removal functions}
