% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsaf.sub.rel.R
\name{cmsaf.sub.rel}
\alias{cmsaf.sub.rel}
\title{Subtract the fields of two input NetCDF files (relative).
Designed for the CM SAF R Toolbox.}
\usage{
cmsaf.sub.rel(
  var1,
  infile1,
  var2,
  infile2,
  outfile,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{var1}{Name of variable in infile1 (character).}

\item{infile1}{Filename of first input NetCDF file. This may include the
directory (character).}

\item{var2}{Name of variable in infile2 (character).}

\item{infile2}{Filename of second input NetCDF file. This may include the
directory (character).}

\item{outfile}{Filename of output NetCDF file. This may include the directory
(character).}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}
}
\value{
A NetCDF file including the subtracted fields of infile1 and infile2
is written.
}
\description{
The function subtracts the fields of infile2 from the fields of infile1.
Infiles have to have the same spatial and temporal dimension.
}
