% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustree.R
\name{clustree}
\alias{clustree}
\alias{clustree.matrix}
\alias{clustree.data.frame}
\alias{clustree.SingleCellExperiment}
\alias{clustree.seurat}
\title{Plot a clustering tree}
\usage{
clustree(x, ...)

\method{clustree}{matrix}(x, prefix, suffix = NULL, metadata = NULL,
  count_filter = 0, prop_filter = 0.1, layout = c("tree", "sugiyama"),
  use_core_edges = TRUE, highlight_core = FALSE, node_colour = prefix,
  node_colour_aggr = NULL, node_size = "size", node_size_aggr = NULL,
  node_size_range = c(4, 15), node_alpha = 1, node_alpha_aggr = NULL,
  node_text_size = 3, scale_node_text = FALSE, node_text_colour = "black",
  edge_width = 1.5, edge_arrow = TRUE, edge_arrow_ends = c("last",
  "first", "both"), return = c("plot", "graph", "layout"), ...)

\method{clustree}{data.frame}(x, prefix, ...)

\method{clustree}{SingleCellExperiment}(x, prefix, exprs = "counts", ...)

\method{clustree}{seurat}(x, prefix = "res.", exprs = c("data", "raw.data",
  "scale.data"), ...)
}
\arguments{
\item{x}{object containing clustering data}

\item{...}{extra parameters passed to other methods}

\item{prefix}{string indicating columns containing clustering information}

\item{suffix}{string at the end of column names containing clustering
information}

\item{metadata}{data.frame containing metadata on each sample that can be
used as node aesthetics}

\item{count_filter}{count threshold for filtering edges in the clustering
graph}

\item{prop_filter}{in proportion threshold for filtering edges in the
clustering graph}

\item{layout}{string specifying the "tree" or "sugiyama" layout, see
\code{\link[igraph:layout_as_tree]{igraph::layout_as_tree()}} and \code{\link[igraph:layout_with_sugiyama]{igraph::layout_with_sugiyama()}} for details}

\item{use_core_edges}{logical, whether to only use core tree (edges with
maximum in proportion for a node) when creating the graph layout, all
(unfiltered) edges will still be displayed}

\item{highlight_core}{logical, whether to increase the edge width of the core
network to make it easier to see}

\item{node_colour}{either a value indicating a colour to use for all nodes or
the name of a metadata column to colour nodes by}

\item{node_colour_aggr}{if \code{node_colour} is a column name than a string
giving the name of a function to aggregate that column for samples in each
cluster}

\item{node_size}{either a numeric value giving the size of all nodes or the
name of a metadata column to use for node sizes}

\item{node_size_aggr}{if \code{node_size} is a column name than a string
giving the name of a function to aggregate that column for samples in each
cluster}

\item{node_size_range}{numeric vector of length two giving the maximum and
minimum point size for plotting nodes}

\item{node_alpha}{either a numeric value giving the alpha of all nodes or the
name of a metadata column to use for node transparency}

\item{node_alpha_aggr}{if \code{node_aggr} is a column name than a string
giving the name of a function to aggregate that column for samples in each
cluster}

\item{node_text_size}{numeric value giving the size of node labels if
\code{scale_node_text} is \code{FALSE}}

\item{scale_node_text}{logical indicating whether to scale node labels along
with the node size}

\item{node_text_colour}{colour value for node labels}

\item{edge_width}{numeric value giving the width of plotted edges}

\item{edge_arrow}{logical indicating whether to add an arrow to edges}

\item{edge_arrow_ends}{string indicating which ends of the line to draw arrow
heads if \code{edge_arrow} is \code{TRUE}, one of "last", "first", or "both"}

\item{return}{string specifying what to return, either "plot" (a \code{ggplot}
object), "graph" (a \code{tbl_graph} object) or "layout" (a \code{ggraph} layout
object)}

\item{exprs}{source of gene expression information to use as node aesthetics,
for \code{SingleCellExperiment} objects it must be a name in \code{assayNames(x)}, for
a \code{seurat} object it must be one of \code{data}, \code{raw.data} or \code{scale.data}}
}
\value{
a \code{ggplot} object (default), a \code{tbl_graph} object or a \code{ggraph}
layout object depending on the value of \code{return}
}
\description{
Creates a plot of a clustering tree showing the relationship between
clusterings at different resolutions.
}
\details{
\strong{Data sources}

Plotting a clustering tree requires information about which cluster each
sample has been assigned to at different resolutions. This information can
be supplied in various forms, as a matrix, data.frame or more specialised
object. In all cases the object provided must contain numeric columns with
the naming structure \code{PXS} where \code{P} is a prefix indicating that the column
contains clustering information, \code{X} is a numeric value indicating the
clustering resolution and \code{S} is any additional suffix to be removed. For
\code{SingleCellExperiment} objects this information must be in the \code{colData} slot
and for \code{Seurat} objects it must be in the \code{meta.data} slot. For all objects
except matrices any additional columns can be used as aesthetics, for
matrices an additional metadata data.frame can be supplied if required.

\strong{Filtering}

Edges in the graph can be filtered by adjusting the \code{count_filter} and
\code{prop_filter} parameters. The \code{count_filter} removes any edges that represent
less than that number of samples, while the \code{prop_filter} removes edges that
represent less than that proportion of cells in the node it points towards.

\strong{Node aesthetics}

The aesthetics of the plotted nodes can be controlled in various ways. By
default the colour indicates the clustering resolution, the size indicates
the number of samples in that cluster and the transparency is set to 100%.
Each of these can be set to a specific value or linked to a supplied metadata
column. For a \code{SingleCellExperiment} or \code{Seurat} object the names of genes
can also be used. If a metadata column is used than an aggregation function
must also be supplied to combine the samples in each cluster. This function
must take a vector of values and return a single value.

\strong{Layout}

The clustering tree can be displayed using either the Reingold-Tilford tree
layout algorithm or the Sugiyama layout algorithm for layered directed
acyclic graphs. These layouts were selected as the are the algorithms
available in the \code{igraph} package designed for trees. The Reingold-Tilford
algorithm places children below their parents while the Sugiyama places
nodes in layers while trying to minimise the number of crossing edges. See
\code{\link[igraph:layout_as_tree]{igraph::layout_as_tree()}} and \code{\link[igraph:layout_with_sugiyama]{igraph::layout_with_sugiyama()}} for more
details. When \code{use_core_edges} is \code{TRUE} (default) only the core tree of the
maximum in proportion edges for each node are used for constructing the
layout. This can often lead to more attractive layouts where the core tree is
more visible.
}
\examples{
data(iris_clusts)
clustree(iris_clusts, prefix = "K")

}
