% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusternor.R
\name{Hmeans}
\alias{Hmeans}
\title{Perform parallel hierarchical clustering on a data matrix.}
\usage{
Hmeans(data, kmax, nrow = -1, ncol = -1, iter.max = 20,
  nthread = -1, init = c("forgy"), tolerance = 1e-06,
  dist.type = c("eucl", "cos", "sqeucl", "taxi"), min.clust.size = 1)
}
\arguments{
\item{data}{Data file name on disk (NUMA optmized) or In memory data matrix}

\item{kmax}{The maximum number of centers}

\item{nrow}{The number of samples in the dataset}

\item{ncol}{The number of features in the dataset}

\item{iter.max}{The maximum number of iteration of k-means to perform}

\item{nthread}{The number of parallel threads to run}

\item{init}{The type of initialization to use c("forgy") or initial centers}

\item{tolerance}{The convergence tolerance for k-means at each
hierarchical split}

\item{dist.type}{What dissimilarity metric to use}

\item{min.clust.size}{The minimum size of a cluster when it cannot be split}
}
\value{
A list of lists containing the attributes of the output of kmeans.
 cluster: A vector of integers (from 1:\strong{k}) indicating the cluster to
         which each point is allocated.
 centers: A matrix of cluster centres.
 size: The number of points in each cluster.
 iter: The number of (outer) iterations.
}
\description{
A recursive (not acutally implemented as recursion) partitioning of data into
 two disjoint sets at every level as described in
 https://en.wikipedia.org/wiki/Hierarchical_clustering
}
\examples{
iris.mat <- as.matrix(iris[,1:4])
kmax <- length(unique(iris[, dim(iris)[2]])) # Number of unique classes
kms <- Hmeans(iris.mat, kmax)

}
\author{
Disa Mhembere <disa@cs.jhu.edu>
}
