% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.r
\name{Q}
\alias{Q}
\title{Queue function calls on the cluster}
\usage{
Q(fun, ..., const = list(), export = list(), seed = 128965,
  memory = NULL, template = list(), n_jobs = NULL, job_size = NULL,
  split_array_by = -1, rettype = "list", fail_on_error = TRUE,
  workers = NULL, log_worker = FALSE, chunk_size = NA,
  timeout = Inf)
}
\arguments{
\item{fun}{A function to call}

\item{...}{Objects to be iterated in each function call}

\item{const}{A list of constant arguments passed to each function call}

\item{export}{List of objects to be exported to the worker}

\item{seed}{A seed to set for each function call}

\item{memory}{Short for template=list(memory=value)}

\item{template}{A named list of values to fill in template}

\item{n_jobs}{The number of LSF jobs to submit; upper limit of jobs
if job_size is given as well}

\item{job_size}{The number of function calls per job}

\item{split_array_by}{The dimension number to split any arrays in `...`; default: last}

\item{rettype}{Return type of function call (vector type or 'list')}

\item{fail_on_error}{If an error occurs on the workers, continue or fail?}

\item{workers}{Optional instance of QSys representing a worker pool}

\item{log_worker}{Write a log file for each worker}

\item{chunk_size}{Number of function calls to chunk together
defaults to 100 chunks per worker or max. 10 kb per chunk}

\item{timeout}{Maximum time in seconds to wait for worker (default: Inf)}
}
\value{
A list of whatever `fun` returned
}
\description{
Queue function calls on the cluster
}
\examples{
\dontrun{
# Run a simple multiplication for numbers 1 to 3 on a worker node
fx = function(x) x * 2
Q(fx, x=1:3, n_jobs=1)
# list(2,4,6)

# Run a mutate() call in dplyr on a worker node
iris \%>\%
    mutate(area = Q(`*`, e1=Sepal.Length, e2=Sepal.Width, n_jobs=1))
# iris with an additional column 'area'
}
}
