% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.ma.normal.R
\name{cpa.ma.normal}
\alias{cpa.ma.normal}
\title{Power calculations for multi-arm cluster randomized trials, continuous outcome}
\usage{
cpa.ma.normal(
  alpha = 0.05,
  power = 0.8,
  narms = NA,
  nclusters = NA,
  nsubjects = NA,
  vara = NA,
  varc = NA,
  vare = NA,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{narms}{The number of independent arms (conditions). It must be greater than 2.}

\item{nclusters}{The number of clusters per arm. It must be greater than 1.}

\item{nsubjects}{The cluster size.}

\item{vara}{The between-arm variance.}

\item{varc}{The between-cluster variance.}

\item{vare}{The within-cluster variance.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
}
\description{
Compute the power of the overall F-test for a multi-arm cluster randomized trial with a continuous
outcome, or determine parameters to obtain a target power.
}
\details{
Exactly one of \code{alpha}, \code{power}, \code{narms}, \code{nclusters},
  \code{nsubjects}, \code{vara}, \code{varc}, and \code{vare}  must be passed as \code{NA}.
  Note that \code{alpha} and \code{power} have non-\code{NA}
  defaults, so if those are the parameters of interest they must be
  explicitly passed as \code{NA}.
  
Assuming a balanced design, the between-arm variance \eqn{\sigma_a^2} (corresponding to
  the function argument \code{vara}) can be estimated using the formula: 
  
  \deqn{\sigma_a^2 = \sum\limits_{i=1}^{n_a}(\mu_i - \mu)^2/(n_a-1)}
  
  where \eqn{n_a} is the number of arms, \eqn{\mu_i} is the estimate of the \eqn{i}-th arm
  mean, and \eqn{\mu} is the estimate of the overall mean of the outcome. This 
  variance can be computed in R using the \code{var} function and a vector of arm means.
  For example, suppose the estimated means for a three-arm trial were 74, 80, and 86 Then the
  estimate of the between-arm variance could be computed with \code{var(c(74,80,86))}, 
  yielding a value of 36.
}
\section{Note}{

  This function was inspired by work from Stephane Champely (pwr.t.test),
  Peter Dalgaard (power.t.test), and Claus Ekstrom (power.anova.test). As 
  with those functions, 'uniroot' is used to solve power equation for
  unknowns, so you may see errors from it, notably about inability to
  bracket the root when invalid arguments are given.
}

\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com}), Ken Kleinman (\email{ken.kleinman@gmail.com})
}

\examples{
# Suppose we are planning a multi-arm trial composed of a control arm and 
# two treatment arms. It is known that each arm will contain 5 clusters. We
# wish to know the minimum number of subjects per cluster necessary to
# attain 80\% power at a 5\% level of significance. A pilot study was used to
# determine estimates of the between-arm variance, the between-cluster 
# variance, and the within-cluster variance. The observed means of each arm
# in the pilot study were 74, 80, and 86, so the  between-arm variance is 36.
# As discussed in the "Details" section above, this can be calculated using
# the command var(c(74,80,86)). The within-cluster and between-cluster
# standard deviations were observed to be 8 and 3, respectively. This means
# the within-cluster and between-cluster variances are 64 and 9, respectively.
# These values are entered into the function as follows:

cpa.ma.normal(narms=3,nclusters=5,vara=36,varc=9,vare=64)
# 
# The result, showing nsubjects of greater than 20, suggests 21 subjects per 
# cluster should be used.
}
\references{
Murray DM. Design and Analysis of Group-Randomized Trials. New York,
  NY: Oxford University Press; 1998.
}
