% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtpwr.2prop.R
\name{crtpwr.2prop}
\alias{crtpwr.2prop}
\title{Power calculations for simple cluster randomized trials, binary outcome}
\usage{
crtpwr.2prop(alpha = 0.05, power = 0.8, m = NA, n = NA, cv = 0,
  p1 = NA, p2 = NA, icc = NA, pooled = FALSE, p1inc = TRUE,
  tol = .Machine$double.eps^0.25)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{m}{The number of clusters per condition. It must be greater than 1.}

\item{n}{The mean of the cluster sizes.}

\item{cv}{The coefficient of variation of the cluster sizes. When \code{cv} = 0,
the clusters all have the same size.}

\item{p1}{The expected proportion in the treatment group.}

\item{p2}{The proportion in the control group.}

\item{icc}{The intraclass correlation.}

\item{pooled}{Logical indicating if pooled standard error should be used.}

\item{p1inc}{Logical indicating if p1 is expected to be greater than p2.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
#' @examples 
# Find the number of clusters per condition needed for a trial with alpha = .05, 
# power = 0.8, 10 observations per cluster, no variation in cluster size, probability
in condition 1 of .1 and condition 2 of .2, and icc = 0.1.
crtpwr.2prop(n=10 ,p1=.1, p2=.2, icc=.1)
# 
# The result, showimg m of greater than 37, suggests 38 clusters per condition should be used.
}
\description{
Compute the power of a simple cluster randomized trial with a binary outcome,
or determine parameters to obtain a target power.
}
\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com})
}

