      SUBROUTINE FANNY(NN,JPP,KK,X,DSS,JDYSS,VALMD,JTMD,NDYST,NSEND,
     F NELEM,NEGBR,SYL,P,DP,PT,NFUZZ,ESP,EF,DVEC,
     F TTSYL,EDA,EDB,OBJ,NCLUV,SYLINF,EPS)
CC
CC   PROGRAM FOR FUZZY CLUSTER ANALYSIS
CC
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
CC  dimension of NSEND,NEGBR,NELEM,NCLUV,DVEC,SYL is MAXNN:
      DIMENSION NSEND(NN),NEGBR(NN),NELEM(NN),NCLUV(NN)
      DIMENSION DVEC(NN),SYL(NN)
CC  dim. X(MAXNN,MAXPP),P(MAXNN,MAXKK),DP(MAXNN,MAXKK),DSS(MAXHH):
      DIMENSION X(NN,JPP),P(NN,KK),DP(NN,KK),DSS(NN*(NN-1)/2+1)
CC  dim. VALMD,JTMD,ESP,EF,PT,NFUZZ(MAXKK):
      DIMENSION VALMD(JPP),JTMD(JPP),OBJ(2)
      DIMENSION PT(KK),NFUZZ(KK),ESP(KK),EF(KK)
      DIMENSION SYLINF(NN,4)
CC
CC   WHERE: 
CC         NN = NUMBER OF OBJECTS
CC         JPP = NUMBER OF VARIABLES FOR CLUSTERING
CC         KK = NUMBER OF CLUSTERS 
CC         MAXHH = (MAXNN*(MAXNN-1))/2 + 1
CC
      IF(JDYSS.EQ.1)GO TO 125
      JHALT=0
      CALL DYSTA3(NN,JPP,X,DSS,NDYST,JTMD,VALMD,JHALT)
      IF(JHALT.EQ.0)GO TO 125
      JDYSS=-1
      RETURN
CC
  125 S=0.0 
      NHALF=NN*(NN-1)/2+1 
      L=1 
  130 L=L+1 
      IF(DSS(L).GT.S)S=DSS(L)
      IF(L.LT.NHALF)GO TO 130 
      CALL FUZZY(NN,NHALF,P,DP,PT,DSS,ESP,EF,EDA,EDB,KK,OBJ,EPS)
      CALL CADDY(NN,P,KK,KTRUE,NFUZZ,NCLUV,PT,NELEM)
      IF(KTRUE.LE.1)GO TO 140
      IF(KTRUE.GE.NN)GO TO 140
      CALL FYGUR(KTRUE,NN,KK,NHALF,NCLUV,NSEND,NELEM
     F,NEGBR,SYL,DVEC,PT,TTSYL,DSS,S,SYLINF)
  140 END
CC
CC
CC
      SUBROUTINE DYSTA3(NN,JPP,X,DSS,NDYST,JTMD,VALMD,JHALT)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(NN,JPP),DSS(1+NN*(NN-1)/2),JTMD(JPP),VALMD(JPP)
      PP=JPP
      NNSUB=NN-1
      NLK=0 
      DO 100 L=1,NNSUB
      LPLUS=L+1 
      DO 20 K=LPLUS,NN  
      CLK=0.0 
      NLK=NLK+1 
      NPRES=0 
      DO 30 J=1,JPP 
      IF(JTMD(J).GE.0)GOTO 40 
      IF(X(L,J).EQ.VALMD(J))GOTO 30 
      IF(X(K,J).EQ.VALMD(J))GOTO 30 
   40 NPRES=NPRES+1 
      IF(NDYST.NE.1)GOTO 50 
      CLK=CLK+(X(L,J)-X(K,J))*(X(L,J)-X(K,J)) 
      GOTO 30 
   50 CLK=CLK+DABS(X(L,J)-X(K,J))
   30 CONTINUE
      RPRES=NPRES 
      IF(NPRES.NE.0)GOTO 60 
      JHALT=1 
      DSS(NLK)=-1.0
      GOTO 20 
   60 IF(NDYST.NE.1)GOTO 70 
      DSS(NLK)=DSQRT(CLK*(PP/RPRES)) 
      GOTO 20 
   70 DSS(NLK)=CLK*(PP/RPRES) 
   20 CONTINUE
  100 CONTINUE
      END 
CC  
CC  
      SUBROUTINE FUZZY(NN,HH,P,DP,PT,DSS,ESP,EF,EDA,EDB,K,OBJ,EPS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER HH
      DIMENSION P(NN,K),DP(NN,K),DSS(HH)
      DIMENSION PT(K),ESP(K),EF(K),OBJ(2)
CC
CC     R IS THE EXPONENT, STRICTLY LARGER THAN 1.0
CC     EPS IS THE PRECISION FOR THE ITERATIONS
CC     NYT IS THE MAXIMAL NUMBER OF ITERATIONS
CC
      R=2.0
      NYT=500
CC
CC   INITIAL FUZZY CLUSTERING 
CC
      NNSUB=NN-1
      RVERS=1./R
      RKME=K-1
      DO 30 M=1,NN
      DO 20 L=1,K
      DP(M,L)=0.
      P(M,L)=0.1/RKME 
   20 CONTINUE
   30 CONTINUE
      NDK=NN/K
      ND=NDK
      L=1 
      DO 50 M=1,NN
      P(M,L)=0.9
      IF(M.LT.ND)GO TO 35
      ND=ND+NDK 
      L=L+1 
      IF(L.EQ.K)ND=NN 
   35 DO 40 LX=1,K
      P(M,LX)=P(M,LX)**R
   40 CONTINUE
   50 CONTINUE
CC
CC   INITIAL CRITERION VALUE
CC
      CRYT=0. 
      DO 100 L=1,K
      ESP(L)=0.
      EF(L)=0.
      DO 90 M=1,NN
      ESP(L)=ESP(L)+P(M,L)
      DO 80 J=1,NN
      IF(J.EQ.M)GO TO 80
      J2=MIN0(M,J)
      J1=(J2-1)*NN-(J2*(J2+1))/2+MAX0(M,J)
      DP(M,L)=DP(M,L)+P(J,L)*DSS(J1)
      EF(L)=EF(L)+P(J,L)*P(M,L)*DSS(J1)
   80 CONTINUE
   90 CONTINUE
      CRYT=CRYT+EF(L)/(ESP(L)*2.)
  100 CONTINUE
      CRT=CRYT
      REEN=1./(R-1.)
CC
CC   START OF ITERATIONS
CC
      KAUNT=1 
      M=0 
CC
CC   THE NEW MEMBERSHIP COEFFICIENTS OF THE OBJECTS ARE CALCULATED, 
CC   AND THE RESULTING VALUE OF THE CRITERION IS COMPUTED.
CC
  200 M=M+1 
      DT=0. 
      DO 210 L=1,K
      PT(L)=((2.*ESP(L)*ESP(L))/(2.*ESP(L)*DP(M,L)-EF(L)))**REEN
      DT=DT+PT(L) 
  210 CONTINUE
      XX=0.
      DO 220 L=1,K
      PT(L)=PT(L)/DT
      IF(PT(L).LE.0.)XX=XX+PT(L)
  220 CONTINUE
      DO 240 L=1,K
      IF(PT(L).LE.0.)PT(L)=0.
      PT(L)=(PT(L)/(1-XX))**R
      ESP(L)=ESP(L)+PT(L)-P(M,L)
      DO 230 J=1,NN
      IF(J.EQ.M)GO TO 230
      J2=MIN0(M,J)
      J1=(J2-1)*NN-(J2*(J2+1))/2+MAX0(M,J)
      DDD=(PT(L)-P(M,L))*DSS(J1)
      DP(J,L)=DP(J,L)+DDD
      EF(L)=EF(L)+2.*P(J,L)*DDD
  230 CONTINUE
      P(M,L)=PT(L)
  240 CONTINUE
      IF(M.LT.NN)GO TO 200
      CRYT=0.
      EDA=0.
      DO 250 L=1,K
      ANN=NN
      EDA=EDA+ESP(L)/ANN
      CRYT=CRYT+EF(L)/(ESP(L)*2.)
  250 CONTINUE
CC  
CC   CRITERION IS PRINTED AND TESTED FOR CONVERGENCE
CC  
      IF((CRT/CRYT-1.).LE.EPS)GO TO 500
      IF(KAUNT.LT.NYT)GO TO 300
      GO TO 500
  300 M=0
      KAUNT=KAUNT+1
      CRT=CRYT
      GO TO 200
CC
CC   NON-FUZZYNESS INDEX OF LIBERT IS COMPUTED
CC  
  500 OBJ(1)=KAUNT
      OBJ(2)=CRYT
      ZK=K
      EDB=(ZK*EDA-1.)/(ZK-1.)
      DO 520 M=1,NN
      DO 510 L=1,K
      P(M,L)=P(M,L)**RVERS
  510 CONTINUE
  520 CONTINUE
      RETURN
      END
CC  
CC
      SUBROUTINE CADDY(NN,P,K,KTRUE,NFUZZ,NCLUV,RDRAW,NELEM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION NCLUV(NN),NELEM(NN),P(NN,K)
      DIMENSION NFUZZ(K),RDRAW(K)
      PBEST=P(1,1)
      NBEST=1 
      DO 10 L=2,K 
      IF(P(1,L).LE.PBEST)GO TO 10 
      PBEST=P(1,L)
      NBEST=L 
   10 CONTINUE
      NFUZZ(1)=NBEST
      NCLUV(1)=1
      KTRUE=1 
      DO 20 M=2,NN
      PBEST=P(M,1)
      NBEST=1 
      DO 30 L=2,K 
      IF(P(M,L).LE.PBEST)GO TO 30 
      PBEST=P(M,L)
      NBEST=L 
   30 CONTINUE
      JSTAY=0 
      DO 40 KTRY=1,KTRUE
      IF(NFUZZ(KTRY).NE.NBEST)GO TO 40
      NCLUV(M)=KTRY 
      JSTAY=1 
   40 CONTINUE
      IF(JSTAY.EQ.1)GO TO 20
      KTRUE=KTRUE+1 
      NFUZZ(KTRUE)=NBEST
      NCLUV(M)=KTRUE
   20 CONTINUE
      IF(KTRUE.GE.K)GO TO 100 
      KNEXT=KTRUE+1 
      DO 60 KWALK=KNEXT,K 
      DO 70 KLEFT=1,K 
      JSTAY=0 
      KSUP=KWALK-1
      DO 80 KTRY=1,KSUP 
      IF(NFUZZ(KTRY).NE.KLEFT)GO TO 80
      JSTAY=1 
   80 CONTINUE
      IF(JSTAY.EQ.1)GO TO 70
      NFUZZ(KWALK)=KLEFT
      GO TO 60
   70 CONTINUE
   60 CONTINUE
  100 DO 110 M=1,NN 
      DO 120 L=1,K
      LFUZZ=NFUZZ(L)
      RDRAW(L)=P(M,LFUZZ) 
  120 CONTINUE
      DO 130 L=1,K
      P(M,L)=RDRAW(L)
  130 CONTINUE
  110 CONTINUE
      END
CC  
CC  
      SUBROUTINE FYGUR(KTRUE,NN,KK,HH,NCLUV,NSEND,NELEM 
     F,NEGBR,SYL,SRANK,AVSYL,TTSYL,DSS,S,SYLINF) 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER HH
      DIMENSION NCLUV(NN),NSEND(NN),NELEM(NN),NEGBR(NN) 
      DIMENSION SYL(NN),SRANK(NN),AVSYL(KK),DSS(HH)
      DIMENSION SYLINF(NN,4)
      NSYLR=0
      TTSYL=0.0 
      DO 100 NUMCL=1,KTRUE
      NTT=0 
      DO 30 J=1,NN
      IF(NCLUV(J).NE.NUMCL)GO TO 30 
      NTT=NTT+1 
      NELEM(NTT)=J
   30 CONTINUE
      DO 40 J=1,NTT 
      NJ=NELEM(J) 
      DYSB=1.1*S+1.0
      NEGBR(J)=-1 
      DO 41 NCLU=1,KTRUE
      IF(NCLU.EQ.NUMCL)GO TO 41 
      NBB=0 
      DB=0.0
      DO 43 L=1,NN
      IF(NCLUV(L).NE.NCLU)GO TO 43
      NBB=NBB+1 
      IF(L.LT.NJ)GO TO 42 
      IF(L.GT.NJ)GO TO 44 
      GO TO 43
   42 MJL=NN*(L-1)+NJ-L*(L+1)/2 
      DB=DB+DSS(MJL)
      GO TO 43
   44 MJL=NN*(NJ-1)+L-NJ*(NJ+1)/2 
      DB=DB+DSS(MJL)  
   43 CONTINUE
      BTT=NBB 
      DB=DB/BTT 
      IF(DB.GE.DYSB)GO TO 41
      DYSB=DB 
      NEGBR(J)=NCLU 
   41 CONTINUE
      IF(NTT.EQ.1)GO TO 50
      DYSA=0.0
      DO 45 L=1,NTT 
      NL=NELEM(L) 
      IF(NJ.LT.NL)GO TO 46
      IF(NJ.GT.NL)GO TO 47
      GO TO 45
   46 NJL=NN*(NJ-1)+NL-NJ*(NJ+1)/2
      DYSA=DYSA+DSS(NJL)
      GO TO 45
   47 NJL=NN*(NL-1)+NJ-NL*(NL+1)/2
      DYSA=DYSA+DSS(NJL)
   45 CONTINUE
      ATT=NTT-1 
      DYSA=DYSA/ATT 
      IF(DYSA.GT.0.0)GO TO 51 
      IF(DYSB.GT.0.0)GO TO 52 
   50 SYL(J)=0.0
      GO TO 40
   52 SYL(J)=1.0
      GO TO 40
   51 IF(DYSB.LE.0.0)GO TO 53 
      IF(DYSB.GT.DYSA)SYL(J)=1.0-DYSA/DYSB
      IF(DYSB.LT.DYSA)SYL(J)=DYSB/DYSA-1.0
      IF(DYSB.EQ.DYSA)SYL(J)=0.0
      GO TO 54
   53 SYL(J)=-1.0 
   54 IF(SYL(J).LE.(-1.0))SYL(J)=-1.0 
      IF(SYL(J).GE.1.0)SYL(J)=1.0 
   40 CONTINUE
      AVSYL(NUMCL)=0.0
      DO 60 J=1,NTT 
      SYMAX=-2.0
      DO 70 L=1,NTT 
      IF(SYL(L).LE.SYMAX)GO TO 70 
      SYMAX=SYL(L)
      LANG=L
   70 CONTINUE
      NSEND(J)=LANG 
      SRANK(J)=SYL(LANG)
      AVSYL(NUMCL)=AVSYL(NUMCL)+SRANK(J)
      SYL(LANG)=-3.0
   60 CONTINUE
      TTSYL=TTSYL+AVSYL(NUMCL)
      RTT=NTT 
      AVSYL(NUMCL)=AVSYL(NUMCL)/RTT 

      IF(NTT.GE.2)GOTO 75 
      NSYLR=NSYLR+1
      SYLINF(NSYLR,1)=NUMCL
      SYLINF(NSYLR,2)=NEGBR(1)
      SYLINF(NSYLR,3)=0.0
      SYLINF(NSYLR,4)=NELEM(1)
      GOTO 100
   75 DO 80 L=1,NTT 
      NSYLR=NSYLR+1
      LPLAC=NSEND(L)
      SYLINF(NSYLR,1)=NUMCL
      SYLINF(NSYLR,2)=NEGBR(LPLAC)
      SYLINF(NSYLR,3)=SRANK(L)
      SYLINF(NSYLR,4)=NELEM(LPLAC)
   80 CONTINUE
  100 CONTINUE
      RNN=NN
      TTSYL=TTSYL/RNN 
      END
