% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStreamsGpu.R
\name{createStreamsGpu}
\alias{createStreamsGpu}
\title{createStreamsGpu}
\usage{
createStreamsGpu(n = prod(getOption("clrng.Nglobal")))
}
\arguments{
\item{n}{a integer specifying number of streams to create, default is the number of total work items in use}
}
\value{
a stream object of class 'vclMatrix' on GPU
}
\description{
Generate streams on a GPU device
}
\examples{
library(clrng)
if (detectGPUs() >= 1) {
 setBaseCreator(rep(12345,6))
 setContext(grep("gpu", listContexts()$device_type)[1])
 myStreamsGpu = createStreamsGpu(4)
 t(as.matrix(myStreamsGpu))

 myStreamsGpu2 = createStreamsGpu(6)
 t(as.matrix(myStreamsGpu2)) }else {
  message("No GPU context available")
}

}
