\name{loadMatrixCLP}
\alias{loadMatrixCLP}

\title{
  Load Constraint Matrix
}

\description{
  Low level interface function to the COIN-OR Clp function
  \code{Clp_loadProblem}. Consult the COIN-OR Clp
  documentation for more detailed information.
}

\usage{
  loadMatrixCLP(lp, ncols, nrows, ia, ja, ra)
}

\arguments{
  \item{lp}{
    A pointer to a COIN-OR Clp problem object.
  }
  \item{ncols}{
    Number of Columns.
  }
  \item{nrows}{
    Number of Rows.
  }
  \item{ia}{
    Row indices in the constraint matrix.
  }
  \item{ja}{
    Column starts in constraint matrix.
  }
  \item{ra}{
    Non zero elements of the constraint matrix.
  }
}

\details{
  Interface to the C function \code{loadMatrix} which calls
  the COIN-OR Clp function \code{Clp_loadProblem}.
}

\value{
  NULL
}

\references{
   The COIN-OR Clp home page at
   \url{http://www.coin-or.org/projects/Clp.xml}
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }

