% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_show.R
\name{cloud_s3_browse}
\alias{cloud_s3_browse}
\title{Browse project's S3 folder}
\usage{
cloud_s3_browse(path = "", root = NULL)
}
\arguments{
\item{path}{(optional) Path inside the S3 folder to open. Defaults to the
root level (path = "") of the project's S3 folder.}

\item{root}{S3 path of the project root. This serves as the reference point
for all relative paths. When left as \code{NULL}, the root is automatically
derived from the \code{cloudfs.s3} field of the project's DESCRIPTION file.}
}
\value{
Invisibly returns \code{NULL}. The primary purpose of this function is its
side effect: opening the specified S3 folder in a browser.
}
\description{
Opens project's S3 folder in browser.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cloud_s3_browse()
cloud_s3_browse("data")
\dontshow{\}) # examplesIf}
}
