% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_show.R
\name{cloud_drive_browse}
\alias{cloud_drive_browse}
\title{Browse project's Google Drive folder}
\usage{
cloud_drive_browse(path = "", root = NULL)
}
\arguments{
\item{path}{(optional) Path inside the Google Drive folder to open. Defaults
to the root level (path = "") of the project's folder.}

\item{root}{Google Drive ID or URL of the project root. This serves as the
reference point for all relative paths. When left as \code{NULL}, the root is
automatically derived from the \code{cloudfs.drive} field of the project's
DESCRIPTION file.}
}
\value{
Invisibly returns \code{NULL}. The primary purpose of this function is its
side effect: opening the specified Google Drive folder in a browser.
}
\description{
Opens project's Google Drive folder in browser.
}
\details{
Google Drive file structure is different from the usual file
structure like e.g. on Linux or Windows. A folder on Google Drive can have
two or more child folders with the same name. Google Drive marks files and
folders with so-called id values to distinguish between them. These values
are always unique. You can see them in browser URL for example. The concept
of "name" is in the first place for convenience of the end user.

In such a setup a relative file path may correspond to multiple files or
folders. This function however works under assumption that the relative
path you pass to it defines strictly one object. If there's any ambiguity
it throws an error.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cloud_drive_browse()
cloud_drive_browse("models/kmeans")
\dontshow{\}) # examplesIf}
}
