/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateStackRequest
extends AmazonWebServiceRequest {
    private String stackName;
    private String templateBody;
    private String templateURL;
    private List<Parameter> parameters;
    private Boolean disableRollback;
    private Integer timeoutInMinutes;
    private List<String> notificationARNs;
    private List<String> capabilities;

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public CreateStackRequest withStackName(String stackName) {
        this.stackName = stackName;
        return this;
    }

    public String getTemplateBody() {
        return this.templateBody;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public CreateStackRequest withTemplateBody(String templateBody) {
        this.templateBody = templateBody;
        return this;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public CreateStackRequest withTemplateURL(String templateURL) {
        this.templateURL = templateURL;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public CreateStackRequest withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public CreateStackRequest withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public Boolean isDisableRollback() {
        return this.disableRollback;
    }

    public void setDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
    }

    public CreateStackRequest withDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
        return this;
    }

    public Boolean getDisableRollback() {
        return this.disableRollback;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public CreateStackRequest withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
        return this;
    }

    public List<String> getNotificationARNs() {
        if (this.notificationARNs == null) {
            this.notificationARNs = new ArrayList<String>();
        }
        return this.notificationARNs;
    }

    public void setNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
            return;
        }
        ArrayList<String> notificationARNsCopy = new ArrayList<String>(notificationARNs.size());
        notificationARNsCopy.addAll(notificationARNs);
        this.notificationARNs = notificationARNsCopy;
    }

    public CreateStackRequest withNotificationARNs(String ... notificationARNs) {
        if (this.getNotificationARNs() == null) {
            this.setNotificationARNs(new ArrayList<String>(notificationARNs.length));
        }
        for (String value : notificationARNs) {
            this.getNotificationARNs().add(value);
        }
        return this;
    }

    public CreateStackRequest withNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
        } else {
            ArrayList<String> notificationARNsCopy = new ArrayList<String>(notificationARNs.size());
            notificationARNsCopy.addAll(notificationARNs);
            this.notificationARNs = notificationARNsCopy;
        }
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.size());
        capabilitiesCopy.addAll(capabilities);
        this.capabilities = capabilitiesCopy;
    }

    public CreateStackRequest withCapabilities(String ... capabilities) {
        if (this.getCapabilities() == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String value : capabilities) {
            this.getCapabilities().add(value);
        }
        return this;
    }

    public CreateStackRequest withCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
        } else {
            ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.size());
            capabilitiesCopy.addAll(capabilities);
            this.capabilities = capabilitiesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName != null) {
            sb.append("StackName: " + this.stackName + ", ");
        }
        if (this.templateBody != null) {
            sb.append("TemplateBody: " + this.templateBody + ", ");
        }
        if (this.templateURL != null) {
            sb.append("TemplateURL: " + this.templateURL + ", ");
        }
        if (this.parameters != null) {
            sb.append("Parameters: " + this.parameters + ", ");
        }
        if (this.disableRollback != null) {
            sb.append("DisableRollback: " + this.disableRollback + ", ");
        }
        if (this.timeoutInMinutes != null) {
            sb.append("TimeoutInMinutes: " + this.timeoutInMinutes + ", ");
        }
        if (this.notificationARNs != null) {
            sb.append("NotificationARNs: " + this.notificationARNs + ", ");
        }
        if (this.capabilities != null) {
            sb.append("Capabilities: " + this.capabilities + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateBody() == null ? 0 : this.getTemplateBody().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateURL() == null ? 0 : this.getTemplateURL().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : ((Object)this.getParameters()).hashCode());
        hashCode = 31 * hashCode + (this.isDisableRollback() == null ? 0 : this.isDisableRollback().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationARNs() == null ? 0 : ((Object)this.getNotificationARNs()).hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : ((Object)this.getCapabilities()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)obj;
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getTemplateBody() == null ^ this.getTemplateBody() == null) {
            return false;
        }
        if (other.getTemplateBody() != null && !other.getTemplateBody().equals(this.getTemplateBody())) {
            return false;
        }
        if (other.getTemplateURL() == null ^ this.getTemplateURL() == null) {
            return false;
        }
        if (other.getTemplateURL() != null && !other.getTemplateURL().equals(this.getTemplateURL())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !((Object)other.getParameters()).equals(this.getParameters())) {
            return false;
        }
        if (other.isDisableRollback() == null ^ this.isDisableRollback() == null) {
            return false;
        }
        if (other.isDisableRollback() != null && !other.isDisableRollback().equals(this.isDisableRollback())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getNotificationARNs() == null ^ this.getNotificationARNs() == null) {
            return false;
        }
        if (other.getNotificationARNs() != null && !((Object)other.getNotificationARNs()).equals(this.getNotificationARNs())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        return other.getCapabilities() == null || ((Object)other.getCapabilities()).equals(this.getCapabilities());
    }
}

