/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui;

import com.norbl.cbp.ppe.AwsClientConfigParams;
import com.norbl.cbp.ppe.gui.LabeledTextField;
import com.norbl.util.gui.GuiUtil;
import com.norbl.util.gui.SwingDefaults;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AwsClientConfigParamsFrame
extends JFrame
implements ActionListener {
    AwsClientConfigParams acc;
    State state = State.active;
    public List<LabeledTextField> params;
    private JButton cancelButton;
    private JPanel framePan;
    private JLabel jLabel1;
    private JLabel notesLabel;
    private JButton okButton;
    private JPanel paramPan;
    private JPanel textPan;

    public AwsClientConfigParamsFrame(AwsClientConfigParams acc) {
        this.acc = acc;
    }

    public void go() {
        this.initComponents();
        SwingDefaults.setIcon(this);
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("OK");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("Cancel");
        this.notesLabel.setText(AwsClientConfigParams.getGuiText());
        this.addParams();
        GuiUtil.centerOnScreen(this);
        this.setVisible(true);
    }

    @Override
    public boolean isActive() {
        return this.state.equals((Object)State.active);
    }

    public boolean isCancelled() {
        return this.state.equals((Object)State.cancelled);
    }

    private void addParams() {
        this.params = new ArrayList<LabeledTextField>();
        for (AwsClientConfigParams.AccParam ap : AwsClientConfigParams.AccParam.values()) {
            String key = ap.toString();
            String val = (String)this.acc.get(key);
            LabeledTextField p = new LabeledTextField(key);
            if (val != null) {
                p.setVal(val);
            }
            p.setAlignmentX(1.0f);
            this.params.add(p);
            this.paramPan.add(p);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd.equals("Cancel")) {
            this.state = State.cancelled;
            this.dispose();
        } else if (cmd.equals("OK")) {
            this.state = State.finished;
            this.dispose();
        }
    }

    private void initComponents() {
        this.framePan = new JPanel();
        this.textPan = new JPanel();
        this.jLabel1 = new JLabel();
        this.notesLabel = new JLabel();
        this.paramPan = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.framePan.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 16));
        this.jLabel1.setText("Amazon Client Configuration Parameters");
        this.notesLabel.setText("The text");
        GroupLayout textPanLayout = new GroupLayout(this.textPan);
        this.textPan.setLayout(textPanLayout);
        textPanLayout.setHorizontalGroup(textPanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(textPanLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 93, Short.MAX_VALUE)).addComponent(this.notesLabel, -1, -1, Short.MAX_VALUE));
        textPanLayout.setVerticalGroup(textPanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(textPanLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(20, 20, 20).addComponent(this.notesLabel, -1, 92, Short.MAX_VALUE)));
        this.paramPan.setLayout(new BoxLayout(this.paramPan, 3));
        this.cancelButton.setText("Cancel");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AwsClientConfigParamsFrame.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout framePanLayout = new GroupLayout(this.framePan);
        this.framePan.setLayout(framePanLayout);
        framePanLayout.setHorizontalGroup(framePanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textPan, -1, -1, Short.MAX_VALUE).addGroup(framePanLayout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 54, -2)).addComponent(this.paramPan, -1, -1, Short.MAX_VALUE));
        framePanLayout.setVerticalGroup(framePanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(framePanLayout.createSequentialGroup().addComponent(this.textPan, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE).addComponent(this.paramPan, -2, 324, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(framePanLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.framePan, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.framePan, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) throws Exception {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AwsClientConfigParamsFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static enum State {
        active,
        finished,
        cancelled;

    }
}

