/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.aws;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class EC2Utils {
    public static Map<String, String> getInstanceMetadata() {
        HashMap<String, String> result = new HashMap<String, String>();
        int retries = 0;
        while (true) {
            try {
                URL url = new URL("http://169.254.169.254/latest/meta-data/");
                BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream()));
                String line = rdr.readLine();
                while (line != null) {
                    try {
                        String val = EC2Utils.getInstanceMetadata(line);
                        result.put(line, val);
                    }
                    catch (IOException ex) {
                        System.err.println("Problem fetching piece of instance metadata! " + ex);
                    }
                    line = rdr.readLine();
                }
                return result;
            }
            catch (IOException ex) {
                if (retries == 5) {
                    System.err.println("Problem getting instance data, retries exhausted...");
                    return result;
                }
                System.err.println("Problem getting instance data, retrying...");
                try {
                    Thread.sleep((int)Math.pow(2.0, retries) * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++retries;
                continue;
            }
            break;
        }
    }

    public static String getInstanceMetadata(String key) throws IOException {
        int retries = 0;
        String value = null;
        while (true) {
            try {
                URL url = new URL("http://169.254.169.254/latest/meta-data/" + key);
                value = new BufferedReader(new InputStreamReader(url.openStream())).readLine();
                return value;
            }
            catch (IOException ex) {
                if (retries == 5) {
                    System.err.println("Problem getting instance data, retries exhausted...");
                    System.err.println("value = " + value);
                    return null;
                }
                System.err.println("Problem getting instance data, retrying...");
                try {
                    Thread.sleep((int)Math.pow(2.0, retries) * 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++retries;
                continue;
            }
            break;
        }
    }

    public static String getInstanceUserdata() throws IOException {
        int retries = 0;
        while (true) {
            try {
                int bytes;
                URL url = new URL("http://169.254.169.254/latest/user-data/");
                InputStreamReader rdr = new InputStreamReader(url.openStream());
                StringWriter wtr = new StringWriter();
                char[] buf = new char[1024];
                while ((bytes = rdr.read(buf)) > -1) {
                    if (bytes <= 0) continue;
                    wtr.write(buf, 0, bytes);
                }
                rdr.close();
                return wtr.toString();
            }
            catch (IOException ex) {
                if (retries == 5) {
                    System.err.println("Problem getting user data, retries exhausted...");
                    return null;
                }
                System.err.println("Problem getting user data, retrying...");
                try {
                    Thread.sleep((int)Math.pow(2.0, retries) * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++retries;
                continue;
            }
            break;
        }
    }

    public static String encodeUserParams(Map<String, String> params) {
        StringBuilder ret = new StringBuilder();
        for (String key : params.keySet()) {
            ret.append(key);
            ret.append("=");
            ret.append(params.get(key));
            ret.append(";");
        }
        return ret.toString();
    }

    public static Map<String, String> decodeUserParams(String params) {
        HashMap<String, String> result = new HashMap<String, String>();
        String param = params.substring(0, params.indexOf(59));
        while (param != null) {
            int idx = param.indexOf(61);
            String key = param.substring(0, idx);
            String value = param.substring(idx + 1);
            result.put(key, value);
            if (param.length() == params.length() - 1) {
                param = null;
                continue;
            }
            params = params.substring(params.indexOf(59) + 1);
            param = params.substring(0, params.indexOf(59));
        }
        return result;
    }
}

