% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.rord.R
\name{cl.rord}
\alias{cl.rord}
\title{Composite Likelihood Calculation for Replciations of Spatial Ordinal Data (for illustration)}
\usage{
cl.rord(theta, response, covar, location, radius = 4)
}
\arguments{
\item{theta}{a vector of parameter value}

\item{response}{a matrix of observation (row: spatial site and column: subject).}

\item{covar}{regression (design) matrix, including intercepts.}

\item{location}{a matrix contains spatial location of sites within each subject}

\item{radius}{radius for selecting pairs for the composite likelihood estimation.}
}
\value{
\code{cl.rord} returns a list: negative composite log-likelihood, a vector of first-order partial derivatives for \code{theta}.
}
\description{
\code{cl.rord} Calculate the negative composite log-likelihood value for replications of spatial ordinal data at given value of parameter value.
Note that this function is not directly used in \code{cle.rord} but illustration only.
}
\examples{
set.seed(1203)
n.subject <- 10
n.lat <- n.lon <- 10
n.site <- n.lat*n.lon

beta <- c(1,2,-1) # First 1 here is the intercept
midalpha <- c(1.15, 2.18) ; sigma2 <- 0.7 ; phi <- 0.8

true = c(midalpha,beta,sigma2,phi)

Xi = rnorm(n.subject,0,1) ; Xj <- rbinom(n.site,1,0.6)

 VV <- matrix(NA, nrow = n.subject*n.site, ncol = 3)

 for(i in 1:n.subject){ for(j in 1:n.site){
     VV[(i-1)*n.site+j,] <- c(1,Xi[i],Xj[j])
       }
 }

location = cbind(rep(seq(1,n.lat,length=n.lat),n.lat),rep(1:n.lon, each=n.lon))
sim.data <- sim.rord(n.subject, n.site, n.rep = 2, midalpha, beta, sigma2, phi, covar=VV, location)

cl.rord(theta=true,response=sim.data[[1]], covar=VV, location, radius = 4)

}
