% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cv.clogitLasso.R
\name{cv.clogitLasso}
\alias{cv.clogitLasso}
\title{Plot coefficients from a \code{clogitLasso} object}
\usage{
cv.clogitLasso(objclogitLasso, K = 10, gpe = NULL)
}
\arguments{
\item{objclogitLasso}{An objet of type \code{clogitLasso}}

\item{K}{The number of folds used in cross validation}

\item{gpe}{A list of group defined by the user.}
}
\value{
An object of type \code{cv.clogitLasso} with the following components:

\item{lambda}{Vector of regularisation parameter}

\item{mean_cv}{vector of mean deviances for each value of the regularisation parameter}

\item{beta}{Vector of estimated coefficients with optimal regularisation parameter}

\item{lambdaopt}{Optimal regularisation parameter}
}
\description{
Plot the parameter profile associated \code{clogitLasso} object
}
\examples{
\dontrun{
 #generate data
 y = rep(c(1,0), 100)
 X = matrix (rnorm(20000, 0, 1), ncol = 100) # pure noise
 strata = sort(rep(1:100, 2))

 fitLasso = clogitLasso(X,y,strata,log=TRUE)
 # Cross validation
 cv.fit = cv.clogitLasso(fitLasso)
 }
}
\author{
Marius Kwemou and Marta Avalos
}
\references{
Avalos, M., Pouyes, H., Grandvalet, Y., Orriols, L., & Lagarde, E. (2015). \emph{Sparse conditional logistic
 regression for analyzing large-scale matched data from epidemiological studies: a simple algorithm.} BMC bioinformatics, 16(6), 1.
}

