% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{compute_normalize}
\alias{compute_normalize}
\title{Trajectory similarity: variable normalization}
\usage{
compute_normalize(res_mat, method = c("none", "range", "sd"), ref_stats = NULL)
}
\arguments{
\item{res_mat}{Trajectory matrix, first column must be time while others are states.}

\item{method}{State normalization method, one of "none", "range", "sd".}

\item{ref_stats}{Optional list containing pre-computed normalization statistics
(e.g., from a previous call to \code{compute_normalize}). Must include:
- For \code{method = "range"}: \code{mins} and \code{maxs} vectors
- For \code{method = "sd"}: \code{means} and \code{sds} vectors}
}
\value{
Normalized trajectory matrix with attribute \code{"ref_stats"} containing
normalization parameters.
}
\description{
Performs per-state normalization by dividing state values by: range (max-min)
or sd (standard deviation). none means no normalization is performed.
}
\examples{
mat <- cbind(time = 1:10, matrix(runif(30, 0, 10), ncol = 3))

# Range normalization with automatic stat computation
norm_mat1 <- compute_normalize(mat, "range")

# Reuse stats for another matrix
mat2 <- cbind(time = 1:10, matrix(runif(30, 5, 15), ncol = 3))
norm_mat2 <- compute_normalize(mat2, "range", attr(norm_mat1, "ref_stats"))
}
