% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year-quarter-day-getters}
\alias{year-quarter-day-getters}
\alias{get_year.clock_year_quarter_day}
\alias{get_quarter.clock_year_quarter_day}
\alias{get_day.clock_year_quarter_day}
\alias{get_hour.clock_year_quarter_day}
\alias{get_minute.clock_year_quarter_day}
\alias{get_second.clock_year_quarter_day}
\alias{get_millisecond.clock_year_quarter_day}
\alias{get_microsecond.clock_year_quarter_day}
\alias{get_nanosecond.clock_year_quarter_day}
\title{Getters: year-quarter-day}
\usage{
\method{get_year}{clock_year_quarter_day}(x)

\method{get_quarter}{clock_year_quarter_day}(x)

\method{get_day}{clock_year_quarter_day}(x)

\method{get_hour}{clock_year_quarter_day}(x)

\method{get_minute}{clock_year_quarter_day}(x)

\method{get_second}{clock_year_quarter_day}(x)

\method{get_millisecond}{clock_year_quarter_day}(x)

\method{get_microsecond}{clock_year_quarter_day}(x)

\method{get_nanosecond}{clock_year_quarter_day}(x)
}
\arguments{
\item{x}{\verb{[clock_year_quarter_day]}

A year-quarter-day to get the component from.}
}
\value{
The component.
}
\description{
These are year-quarter-day methods for the
\link[=clock-getters]{getter generics}.
\itemize{
\item \code{get_year()} returns the fiscal year. Note that this can differ from the
Gregorian year if \code{start != 1L}.
\item \code{get_quarter()} returns the fiscal quarter as a value between 1-4.
\item \code{get_day()} returns the day of the fiscal quarter as a value between 1-92.
\item There are sub-daily getters for extracting more precise components.
}
}
\examples{
x <- year_quarter_day(2020, 1:4)

get_quarter(x)

# Set and then get the last day of the quarter
x <- set_day(x, "last")
get_day(x)

# Start the fiscal year in November and choose the 50th day in
# each quarter of 2020
november <- 11
y <- year_quarter_day(2020, 1:4, 50, start = 11)
y

get_day(y)

# What does that map to in year-month-day?
as_year_month_day(y)
}
