% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-palettes.R
\name{getColorPalette}
\alias{getColorPalette}
\title{Get a color palette for clinical
visualizations.}
\usage{
getColorPalette(n = NULL, x = NULL, includeNA = FALSE, palette = clinColors)
}
\arguments{
\item{n}{Integer of length 1, number of elements in palette.}

\item{x}{Vector with elements used for palette.
If factor, the levels are used, otherwise the unique elements of the vector.
Missing values are automatically removed, excepted if
\code{includeNA} is set to TRUE.}

\item{includeNA}{Logical (FALSE by default), 
should NA elements be retained in the palette in case
\code{x} is specified?}

\item{palette}{A vector of custom colors,
or a function returning this vector from a specific
number of colors.\cr
Default is the the colorblind 
\code{\link[viridisLite]{viridis}} color palette.}
}
\value{
Vector of colors,
named with the elements in \code{x} if \code{x} is specified.
}
\description{
Get a color palette of specified length,
either from a vector of names for the palette, or
from a specified length.
}
\examples{
# extract longest palette available
getColorPalette(n = 11)
# extract palette for a vector
getColorPalette(x = paste('treatment', 1:4))
# possibility to include missing values:
getColorPalette(x = c(NA_character_, "group1"), includeNA = FALSE)
getColorPalette(x = c(NA_character_, "group1"), includeNA = TRUE)
# change default settings
getColorPalette(n = 3, palette = c("red", "green", "grey"))
}
\author{
Laure Cougnaud and Michela Pasetto
}
