% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTables.R
\name{formatDetailsComparison}
\alias{formatDetailsComparison}
\title{Format details comparison}
\usage{
formatDetailsComparison(
  diffData,
  referenceVars = attr(diffData, "referenceVars"),
  changeableVars = attr(diffData, "changeableVars")
)
}
\arguments{
\item{diffData}{Object of class 'diff.data' containing
differences between datasets, as returned by the \code{\link{compareDiff}} function.}

\item{referenceVars}{character vector of the columns in the data that are the used as
reference for the comparison. \cr 
If not specified, all columns present both in
\code{newData} and \code{oldData} are considered.}

\item{changeableVars}{character vector of the columns in the data for which you want to assess the change,
e.g. variables that might have changed from the old to the new data.\cr
If not specified, only 'Addition' and 'Removal' are detected.}
}
\value{
\code{diffData} with extra columns:
'[].diff' for the \code{referenceVars} and \code{changeableVars}
columns, and attributes: 'colsDiff' as a named vector
with mapping with input variables (names) and corresponding
diff variables.
}
\description{
Format details comparison
}
\author{
Laure Cougnaud
}
