% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-staticScatterplotClinData.R
\name{staticScatterplotClinData}
\alias{staticScatterplotClinData}
\title{Scatterplot of variables of interest for clinical data visualization}
\usage{
staticScatterplotClinData(
  data,
  xVar,
  yVar,
  xLab = getLabelVar(xVar, labelVars = labelVars),
  yLab = getLabelVar(yVar, labelVars = labelVars),
  aesPointVar = list(),
  pointPars = list(),
  aesLineVar = list(),
  linePars = list(),
  lineInclude = length(c(aesLineVar, linePars)) > 0,
  aesSmoothVar = list(),
  smoothPars = list(),
  smoothInclude = length(c(aesSmoothVar, smoothPars)) > 0,
  aesLab,
  xTrans = "identity",
  yTrans = "identity",
  xPars = list(),
  yPars = list(),
  xLabVars = NULL,
  yLim = NULL,
  xLim = NULL,
  yLimExpandData = TRUE,
  xLimExpandData = TRUE,
  titleExtra = NULL,
  title = paste(paste(yLab, "vs", xLab, titleExtra), collapse = "<br>"),
  facetPars = list(),
  facetType = c("wrap", "grid"),
  scalePars = list(),
  themePars = list(legend.position = "bottom"),
  refLinePars = NULL,
  labelVars = NULL,
  hoverVars = NULL,
  geomType = c("point", "col")
)
}
\arguments{
\item{data}{Data.frame with input data.}

\item{xVar}{String with column of \code{data} containing x-variable.}

\item{yVar}{String with column of \code{data} containing y-variable.}

\item{xLab}{String with label for \code{xVar}.}

\item{yLab}{String with label for \code{xVar}.}

\item{aesPointVar}{List with specification of aesthetic variable(s),
for the point, passed to the \code{mapping} parameter of \code{\link[ggplot2]{geom_point}},
e.g. \code{list(color = "TRTP")}.\cr
Please note by default symbols with fill and color are used.
Color is used for the outside of the points, fill for the inside
and the hover. Usually, you might want to specify both
filling and coloring.}

\item{pointPars}{List with parameters other than aesthetic variables to pass to \code{\link[ggplot2]{geom_point}},
defaults to empty list.}

\item{aesLineVar}{List with specification of aesthetic variable(s),
for the line, passed to the \code{mapping} parameter of \code{\link[ggplot2]{geom_line}},
e.g. \code{list(group = "USUBJID")}.}

\item{linePars}{List with parameters other than aesthetic variables to pass to \code{\link[ggplot2]{geom_line}},
defaults to empty list.}

\item{lineInclude}{Logical, if TRUE (by default if \code{aesLineVar} is specified)
include a scatterplot.}

\item{aesSmoothVar}{List with specification of aesthetic variable(s),
for the smoothing layer, passed to the \code{mapping} parameter of \code{\link[ggplot2]{geom_smooth}} defaults to empty list.}

\item{smoothPars}{List with parameters other than aesthetic variables to pass to \code{\link[ggplot2]{geom_smooth}},
defaults to empty list. Note this parameter overwrites other parameters set by \code{aesSmoothVar}.}

\item{smoothInclude}{Logical, if TRUE (by default if one of \code{aesSmoothVar or smoothPars} is non-empty)}

\item{aesLab}{Named character vector with labels for each aesthetic variable.}

\item{xTrans, yTrans}{Transformation for the x/y- variables,
passed to the \code{trans} parameter of \code{\link[ggplot2]{scale_x_continuous}}/
\code{\link[ggplot2]{scale_y_continuous}}.}

\item{xPars, yPars}{List with extra parameters for x/y axis, passed to the
\code{\link[ggplot2]{scale_x_continuous}}/
\code{\link[ggplot2]{scale_y_continuous}} functions,
besides \code{trans} and \code{limits}.}

\item{xLabVars}{Character vector with variable(s) to be displayed 
as the labels of the ticks in the x-axis.\cr
By default, \code{xVar} is displayed.\cr
If specified, this overwrites any \code{labels} specified via \code{xPars}.\cr
In case the variable(s) contain different elements 
by \code{xVar} or between facets, they are combined
and displayed below each other.}

\item{xLim, yLim}{Numeric vector of length 2 with limits for the x/y axes.}

\item{xLimExpandData, yLimExpandData}{Logical (TRUE by default), should the
limits specified via \code{xLim}/\code{yLim} be 
expanded to include any data points outside of these
limits?
Please note that the same limits are set for all facets.}

\item{titleExtra}{String with extra title for the plot (appended after \code{title}).}

\item{title}{String with title for the plot.}

\item{facetPars}{List with facetting parameters, passed to the facetting function.}

\item{facetType}{String with facetting type, either:
\itemize{
\item{'wrap': }{\code{\link[ggplot2]{facet_wrap}}}
\item{'grid': }{\code{\link[ggplot2]{facet_grid}}}
}}

\item{scalePars}{List with parameters to customize
scales. Each sublist should contains a set of parameters
passed to the \code{\link[ggplot2]{scale_discrete_manual}}
function.\cr
If palette(s) are not specified, default palettes are used
(see \link[clinUtils]{getColorPalette}, 
\link[clinUtils]{getShapePalette}, 
\link[clinUtils]{getLinetypePalette}
)}

\item{themePars}{List with general theme parameters 
(see \code{\link[ggplot2]{theme}}).}

\item{refLinePars}{(optional) Nested list, with parameters for each reference line(s).
Each sublist (a.k.a reference line) contains:
\itemize{
\item{aesthetic value(s) or variable(s) for the lines
(in this case column names of \code{data}) for reference lines.
The line position is controlled by the aesthetics supported in
\code{\link[ggplot2]{geom_vline}}, \code{\link[ggplot2]{geom_hline}} 
and \code{\link[ggplot2]{geom_abline}}.
}
\item{'label': }{(optional) Logical specifying if the line
should be annotated (\code{FALSE} to not annotate the line)
or string with annotation label. By default, the value
of the position of the horizontal/vertical line or the equation
of the diagonal line is displayed.
}
}}

\item{labelVars}{Named character vector containing variable labels.}

\item{hoverVars}{Character vector with variables to be displayed in the hover,
by default \code{xVar}, \code{yVar} and any aesthetic variables.}

\item{geomType}{String with type of the geom used, either:
\itemize{
\item{'point': }{scatterplot with \code{\link[ggplot2]{geom_point}} is created}
\item{'col': }{barplot with \code{\link[ggplot2]{geom_col}} is created}
}}
}
\value{
\code{\link[ggplot2]{ggplot}} object
}
\description{
Scatterplot of variables of interest for clinical data visualization
}
\author{
Laure Cougnaud, Adriaan Blommaert
}
