% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotcor.R
\name{plotcor}
\alias{plotcor}
\title{Visualise climate cross correlation or autocorrelation.}
\usage{
plotcor(cor.output, type = type)
}
\arguments{
\item{cor.output}{Output of \code{\link{autowin}} or
\code{\link{crosswin}}}

\item{type}{Should be either "A" for data generated by \code{\link{autowin}}
or "C" for data generated by \code{\link{crosswin}}.}
}
\value{
Will generate a colour plot to visualise the correlation data.
}
\description{
Create a colour plot to visualise the results of \code{\link{autowin}} or
\code{\link{crosswin}}. Displays correlation across all desired climate
windows.
}
\examples{
\dontrun{
# Visualise climate autocorrelation

data(Mass)
data(MassClimate)

# Fit a single climate window using the datasets Mass and MassClimate.

single <- singlewin(xvar = list(Temp = MassClimate$Temp),
                   cdate = MassClimate$Date, bdate = Mass$Date,
                   baseline = lm(Mass ~ 1, data = Mass),
                   furthest = 72, closest = 15,
                   stat = "mean", func = "lin",
                   type = "fixed", cutoff.day = 20, cutoff.month = 5,
                   cmissing = FALSE, cinterval = "day")

# Test the autocorrelation between the climate in this single window and other climate windows.

auto <- autowin(reference = single$BestModelData$climate,
               xvar  = list(Temp = MassClimate$Temp),
               cdate = MassClimate$Date, bdate = Mass$Date,
               baseline = lm(Mass ~ 1, data = Mass),
               furthest = 365, closest = 0,
               stat = "mean", func = "lin",
               type = "fixed", cutoff.day = 20, cutoff.month = 5,
               cmissing = FALSE, cinterval = "day")

# Plot the auto-correlation data

plotcor(auto, type = "A")
}
}
\author{
Liam D. Bailey and Martijn van de Pol
}

