% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotall.R
\name{plotall}
\alias{plotall}
\title{Visualise climate window data}
\usage{
plotall(dataset, datasetrand = NULL, bestmodel = NULL,
  bestmodeldata = NULL, cw1 = 0.95, cw2 = 0.5, cw3 = 0.25,
  histq = 0.99, title = NULL)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{climatewin}}.}

\item{datasetrand}{A dataframe containing information on all fitted climate
windows using randomised data. Output from \code{\link{randwin}}.}

\item{bestmodel}{A model object. The strongest climate window model. Returned
from \code{\link{singlewin}} or \code{\link{climatewin}}.}

\item{bestmodeldata}{A dataframe containing the biological and climate data
used to fit the strongest climate window model. Output from
\code{\link{singlewin}} or \code{\link{climatewin}}.}

\item{cw1,cw2,cw3}{Cumulative weight levels used to visualise model weight
distribution. See \code{\link{plotweights}} for more detail.}

\item{histq}{If datasetrand is provided. The quantile of the randomised data
to be compared with non-randomised data. Can be used to determine the
likelihood of finding a climate window model of a given deltaAICc value by
chance.}

\item{title}{Title of the plot panel.}
}
\value{
Will return a panel of 6-8 plots:

 \itemize{
 \item DeltaAICc: A colour plot of model deltaAICc values (larger
 negative values indicate stronger models). DeltaAICc is the difference
 between AICc of each climate window model and the baseline model containing
 no climate data.

 \item Model weight: A plot showing the distribution of cumulative
 model weights. Gradient levels determined by parameters cw1, cw2 and cw3.
 Darker areas have a higher chance of containing the best climate window.

 \item Model betas: A colour plot of model beta estimates. Where applicable,
 2nd order coefficients (quadratic) and 3rd order coefficients (cubic) will
 be plotted separately.

 \item Histogram(s): If datasetrand is provided, plotall will create two
 stacked histograms to compare the deltaAICc of non-randomised and randomised
 data. This can help determine the likelihood of obtaining a deltaAICc value
 for a fitted climate window model at random. Without datasetrand, plotall
 will create a single histogram of deltaAICc values for all fitted climate
 windows.

 \item Boxplots: Two boxplots showing the opening and closing day for a
 subset of best climate windows. Best climate windows make up the
 cumulative model weight equivalent to the largest value of cw1, cw2 and cw3.
 Values above boxplots represent the median values.

 \item Best Model: If bestmodel and bestmodeldata are provided, plotall will
 create a scatterplot to show the fit of the best model through the data. }
}
\description{
Creates a panel of plots to help visualise climate window data.
}
\examples{
# Visualise a fixed climate window generated for dataframes Mass and MassClimate

data(MassOutput)
data(Mass)
data(MassClimate)

single <- singlewin(xvar = list(Temp = MassClimate$Temp),
                   cdate = MassClimate$Date, bdate = Mass$Date,
                   baseline = lm(Mass ~ 1, data = Mass),
                   furthest = 72, closest = 15,
                   stat = "mean", func = "lin",
                   type = "fixed", cutoff.day = 20, cutoff.month = 5,
                   cmissing = FALSE, cinterval = "day")

plotall(dataset = MassOutput, bestmodel = single$bestmodel,
       bestmodeldata = single$bestmodeldata,
       cw1 = 0.95, cw2 = 0.5, cw3 = 0.25, histq = 0.99, title = "Mass")
}
\author{
Liam D. Bailey and Martijn van de Pol
}

