% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotcor.R
\name{plotcor}
\alias{plotcor}
\title{Visualise climate cross correlation or autocorrelation.}
\usage{
plotcor(CorWindowOutput, TYPE = TYPE)
}
\arguments{
\item{CorWindowOutput}{Output of \code{\link{autowin}} or
\code{\link{crosswin}}}

\item{TYPE}{Should be either "A" for data generated by \code{\link{autowin}}
or "C" for data generated by \code{\link{crosswin}}.}
}
\value{
Will generate a colour plot to visualise the correlation data.
}
\description{
Create a colour plot to visualise the results of \code{\link{autowin}} or
\code{\link{crosswin}}. Displays correlation across all desired climate
windows.
}
\examples{
\dontrun{
# Visualise climate autocorrelation

data(Mass)
data(MassClimate)

# Fit a single climate window using the datasets Mass and MassClimate.

single <- singlewin(Xvar = MassClimate$Temp, CDate = MassClimate$Date, BDate = Mass$Date,
                    baseline = lm(Mass ~ 1, data = Mass), furthest = 72, closest = 15,
                    STAT = "mean", FUNC = "L",
                    FIXED = TRUE, cutoff.day = 20, cutoff.month = 5,
                    CMISSING = FALSE, CINTERVAL = "D")

# Test the autocorrelation between the climate in this single window and other climate windows.

auto <- autowin(reference = single[[2]]$temporary,
                Xvar  = MassClimate$Temp, CDate = MassClimate$Date, BDate = Mass$Date,
                furthest = 365, closest = 0, STAT = "mean",
                FIXED = TRUE, cutoff.day = 20, cutoff.month = 5,
                CMISSING = FALSE, CINTERVAL = "D")

# Plot the auto-correlation data

plotcor(auto, TYPE = "A")
}
}
\author{
Liam D. Bailey and Martijn van de Pol
}

