% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansi-hyperlink.R
\name{style_hyperlink}
\alias{style_hyperlink}
\alias{ansi_has_hyperlink_support}
\alias{ansi_hyperlink_types}
\title{Terminal Hyperlinks}
\usage{
style_hyperlink(text, url, params = NULL)

ansi_has_hyperlink_support()

ansi_hyperlink_types()
}
\arguments{
\item{text}{Text to show. \code{text} and \code{url} are recycled to match their
length, via a \code{paste0()} call.}

\item{url}{URL to link to.}

\item{params}{A named character vector of additional parameters, or \code{NULL}.}
}
\value{
Styled \code{cli_ansi_string} for \code{style_hyperlink()}.
Logical scalar for \code{ansi_has_hyperlink_support()}.
}
\description{
\code{ansi_hyperlink()} creates an ANSI hyperlink.
}
\details{
This function is currently experimental. In particular, many of the
\verb{ansi_*()} functions do not support it properly.

\code{ansi_has_hyperlink_support()} checks if the current \code{stdout()}
supports hyperlinks.

See also
\url{https://gist.github.com/egmontkob/eb114294efbcd5adb1944c9f3cb5feda}.

\code{ansi_hyperlink_types()} checks if current \code{stdout()} supports various
types of hyperlinks. It returns a list with entries \code{href}, \code{run},
\code{help} and \code{vignettes}.
}
\examples{
cat("This is an", style_hyperlink("R", "https://r-project.org"), "link.\n")
ansi_has_hyperlink_support()
}
