% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{cli-config}
\alias{cli-config}
\title{cli environment variables and options}
\description{
cli environment variables and options
}
\section{User facing configuration}{


These are environment variables and options that uses may set, to modify
the behavior of cli.
\subsection{User facing environment variables}{
\subsection{\code{NO_COLOR}}{

Set to a nonempty value to turn off ANSI colors.
See \code{\link[=num_ansi_colors]{num_ansi_colors()}}.
}

\subsection{\code{R_CLI_DYNAMIC}}{

Set to \code{true}, \code{TRUE} or \code{True} to assume a dynamic terminal, that supports \verb{\\r}.
Set to anything else to assume a non-dynamic terminal.
See \code{\link[=is_dynamic_tty]{is_dynamic_tty()}}.
}

\subsection{\code{R_CLI_NUM_COLORS}}{

Set to a positive integer to assume a given number of colors.
See \code{\link[=num_ansi_colors]{num_ansi_colors()}}.
}

}

\subsection{User facing options}{
\subsection{\code{cli.ansi}}{

Set to \code{true}, \code{TRUE} or \code{True} to assume a terminal that supports ANSI
control sequences.
Set to anything else to assume a non-ANSI terminal.
See \code{\link[=is_ansi_tty]{is_ansi_tty()}}.
}

\subsection{\code{cli.condition_width}}{

Integer scalar (or \code{Inf}) to set the console width when cli is formatting
errors, warnings or messages in \code{format_error()}, \code{format_warning()} and
\code{format_message()}. When formatting conditions this option takes precedence
over \code{cli.width}.
}

\subsection{\code{cli.default_handler}}{

General handler function for all cli conditions.
See \url{https://cli.r-lib.org/articles/semantic-cli.html#cli-messages-1}
}

\subsection{\code{cli.dynamic}}{

Set to \code{TRUE} to assume a dynamic terminal, that supports \verb{\\r}.
Set to anything else to assume a non-dynamic terminal.
See \code{\link[=is_dynamic_tty]{is_dynamic_tty()}}.
}

\subsection{\code{cli.hide_cursor}}{

Whether the cli status bar should try to hide the cursor on terminals.
Set the \code{FALSE} if the hidden cursor causes issues.
}

\subsection{\code{cli.hyperlink}}{

Set to \code{true}, \code{TRUE} or \code{True} to tell cli that the terminal supports
ANSI hyperlinks.
Set to anything else to assume no hyperlink support.
See \code{\link[=style_hyperlink]{style_hyperlink()}}.
}

\subsection{\code{cli.num_colors}}{

Number of ANSI colors. See \code{\link[=num_ansi_colors]{num_ansi_colors()}}.
}

\subsection{\code{cli.message_class}}{

Character vector of classes to add to cli's conditions.
}

\subsection{\code{cli.progress_bar_style}}{

Progress bar style.
See \code{\link[=cli_progress_styles]{cli_progress_styles()}}.
}

\subsection{\code{cli.progress_bar_style_ascii}}{

Progress bar style on ASCII consoles.
See \code{\link[=cli_progress_styles]{cli_progress_styles()}}.
}

\subsection{\code{cli.progress_bar_style_unicode}}{

Progress bar style on Unicode (UTF-8) consoles;
See \code{\link[=cli_progress_styles]{cli_progress_styles()}}.
}

\subsection{\code{cli.progress_clear}}{

Whether to clear terminated progress bar from the screen on dynamic terminals.
See \code{\link[=cli_progress_bar]{cli_progress_bar()}}.
}

\subsection{\code{cli.progress_demo_live}}{

Whether \code{cli_progress_demo()} should show a live demo, or just record the
progress bar frames.
}

\subsection{\code{cli.progress_format_download}}{

Default format string for \code{download} progress bars.
}

\subsection{\code{cli.progress_format_download_nototal}}{

Default format string for \code{download} progress bars with unknown totals.
}

\subsection{\code{cli.progress_format_iterator}}{

Default format string for \code{iterator} progress bars.
}

\subsection{\code{cli.progress_format_iterator_nototal}}{

Default format string for \code{iterator} progress bars with unknown total number
of progress units.
}

\subsection{\code{cli.progress_format_tasks}}{

Default format string for \code{tasks} progress bars.
}

\subsection{\code{cli.progress_format_tasks_nototal}}{

Default format string for \code{tasks} progress bars with unknown totals.
}

\subsection{\code{cli.progress_handlers}}{

Progress handlers to try.
See \code{\link[=cli_progress_builtin_handlers]{cli_progress_builtin_handlers()}}.
}

\subsection{\code{cli.progress_handlers_force}}{

Progress handlers that will always be used, even if another handler
was already selected.
See \code{\link[=cli_progress_builtin_handlers]{cli_progress_builtin_handlers()}}.
}

\subsection{\code{cli.progress_handlers_only}}{

Progress handlers to force, ignoring handlers set in
\code{cli.progress_handlers} and \code{cli.progress_handlers_force}.
See \code{\link[=cli_progress_builtin_handlers]{cli_progress_builtin_handlers()}}.
}

\subsection{\code{cli.progress_say_args}}{

Command line arguments for the \code{say} progress handlers.
See \code{\link[=cli_progress_builtin_handlers]{cli_progress_builtin_handlers()}}.
}

\subsection{\code{cli.progress_say_command}}{

External command to use in the \code{say} progress handler.
See \code{\link[=cli_progress_builtin_handlers]{cli_progress_builtin_handlers()}}.
}

\subsection{\code{cli.progress_say_frequency}}{

Minimum delay between \code{say} calls in the \code{say} progress handler.
\code{say} ignores very frequent updates, to keep the speech comprehensible.
See \code{\link[=cli_progress_builtin_handlers]{cli_progress_builtin_handlers()}}.
}

\subsection{\code{cli.progress_show_after}}{

Delay before showing a progress bar, in seconds.
Progress bars that finish before this delay are not shown at all.
}

\subsection{\code{cli.spinner}}{

Default spinner to use, see \code{\link[=get_spinner]{get_spinner()}}.
}

\subsection{\code{cli.spinner_ascii}}{

Default spinner to use on ASCII terminals, see \code{\link[=get_spinner]{get_spinner()}}.
}

\subsection{\code{cli.spinner_unicode}}{

Default spinner to use on Unicode terminals, see \code{\link[=get_spinner]{get_spinner()}}.
}

\subsection{\code{cli.theme}}{

Default cli theme, in addition to the built-in theme.
This option in intended for the package developers.
See \link{themes} and \code{\link[=start_app]{start_app()}}.
}

\subsection{\code{cli_theme_dark}}{

Whether cli should assume a dark theme for the builtin theme.
See \code{\link[=builtin_theme]{builtin_theme()}}.
}

\subsection{\code{cli.unicode}}{

Whether to assume a Unicode terminal.
If not set, then it is auto-detected.
See \code{\link[=is_utf8_output]{is_utf8_output()}}.
}

\subsection{\code{cli.user_theme}}{

cli user theme.
This option is intended for end users.
See \link{themes}.
}

\subsection{\code{cli.width}}{

Terminal width to assume.
If not set, then it is auto-detected.
See \code{\link[=console_width]{console_width()}}.
}

\subsection{\code{rlib_interactive}}{

Whether to assume an interactive R session.
If not set, then it is auto-detected.
}

\subsection{\code{width}}{

Terminal width.
This is used on some platforms, if \code{cli.width} is not set.
}

}
}

\section{Internal configuration}{


These are environment variables and options are for cli developers, users
should not rely on them as they may change between cli releases.
\subsection{Internal environment variables}{
\subsection{\code{ASCIICAST}}{

Used to detect an asciicast sub-process in RStudio.
}

\subsection{\code{ANSICON}}{

Used to detect ANSICON when detecting the number of ANSI colors.
}

\subsection{\code{CI}}{

Used to detect if the code is running on a CI.
If yes, we avoid ANSI hyperlinks.
}

\subsection{\code{CLI_DEBUG_BAD_END}}{

Whether to warn about \code{cli_end()} calls when there is no container to close.
}

\subsection{\code{CLI_NO_BUILTIN_THEME}}{

Set it to \code{true} to omit the builtin theme.
}

\subsection{\code{CLI_SPEED_TIME}}{

Can be used to speed up cli's timer.
It is a factor, e.g. setting it to 2 makes cli's time go twice as fast.
}

\subsection{\code{CLI_TICK_TIME}}{

How often the cli timer should alert, in milliseconds.
}

\subsection{\code{CMDER_ROOT}}{

Used to detect cmder when detecting the number of ANSI colors.
}

\subsection{\code{COLORTERM}}{

Used when detecting ANSI color support.
}

\subsection{\code{ConEmuANSI}}{

Used to detect ConEmu when detecting the number of ANSI colors.
}

\subsection{\code{EMACS}}{

Used to detect Emacs.
}

\subsection{\code{INSIDE_EMACS}}{

Used to detect Emacs.
}

\subsection{\code{NOT_CRAN}}{

Set to \code{true} to run tests / examples / checks, that do not run on CRAN.
}

\subsection{\verb{_R_CHECK_PACKAGE_NAME_}}{

Used to detect \verb{R CMD check}.
}

\subsection{\code{R_BROWSER}}{

Used to detect the RStudio build pane.
}

\subsection{\code{R_GUI_APP_VERSION}}{

Used to detect R.app on macOS, to decide if the console has ANSI control
sequences.
}

\subsection{\code{R_PACKAGE_DIR}}{

Used to detect if the code is running under \verb{R CMD INSTALL}.
}

\subsection{\code{R_PDFVIEWER}}{

Used to detect the RStudio build pane.
}

\subsection{\code{R_PROGRESS_NO_EXAMPLES}}{

Set to \code{true} to avoid running examples, outside of \verb{R CMD check}.
}

\subsection{\code{RSTUDIO}}{

Used to detect RStudio, in various functions.
}

\subsection{\code{RSTUDIO_CONSOLE_COLOR}}{

Used to detect the number of colors in RStudio.
See \code{\link[=num_ansi_colors]{num_ansi_colors()}}.
}

\subsection{\code{RSTUDIO_CONSOLE_WIDTH}}{

Used to auto-detect console width in RStudio.
}

\subsection{\code{RSTUDIO_TERM}}{

Used to detect the RStudio build pane.
}

\subsection{\code{TEAMCITY_VERSION}}{

Used to detect the TeamCity CI, to turn off ANSI hyperlinks.
}

\subsection{\code{TERM}}{

Used to detect if the console has ANSI control sequences, in a terminal.
}

\subsection{\code{TERM_PROGRAM}}{

Used to detect iTerm for the dark theme detection and the ANSI hyperlink
support detection.
}

\subsection{\code{TERM_PROGRAM_VERSION}}{

Used to detect a suitable iTerm version for ANSI hyperlink support.
}

\subsection{\code{TESTTHAT}}{

Used to detect running in testthat tests.
}

\subsection{\code{VTE_VERSION}}{

Used to detect a suitable VTE version for ANSI hyperlinks.
}

}

\subsection{Internal options}{
\subsection{\code{cli__pb}}{

This option is set to the progress bar that is being updated, when
interpolating the format string.
}

\subsection{\code{cli.record}}{

Internal option to mark the state that cli is recording messages.
}

\subsection{\code{crayon.colors}}{

Deprecated option for the number of ANSI colors, that is still supported
by cli, when the new options are not set.
See \code{\link[=num_ansi_colors]{num_ansi_colors()}}.
}

\subsection{\code{crayon.enabled}}{

Deprecated option to turn ANSI colors on/off.
This is still supported by cli when the new options are not set.
See \code{\link[=num_ansi_colors]{num_ansi_colors()}}.
}

\subsection{\code{crayon.hyperlink}}{

Whether to assume ANSI hyperlink support.
See \code{\link[=ansi_has_hyperlink_support]{ansi_has_hyperlink_support()}}.
}

\subsection{\code{knitr.in.progress}}{

Used to detect knitr when detecting interactive sessions and ANSI color
support.
}

\subsection{\code{rstudio.notebook.executing}}{

Used to detect knitr when detecting interactive sessions.
}

}
}

