% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_rule}
\alias{cli_rule}
\title{CLI horizontal rule}
\usage{
cli_rule(
  left = "",
  center = "",
  right = "",
  id = NULL,
  .envir = parent.frame()
)
}
\arguments{
\item{left}{Label to show on the left. It interferes with the \code{center}
label, only at most one of them can be present.}

\item{center}{Label to show at the center. It interferes  with the
\code{left} and \code{right} labels.}

\item{right}{Label to show on the right. It interferes with the \code{center}
label, only at most one of them can be present.}

\item{id}{Element id, a string. If \code{NULL}, then a new id is generated
and returned.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
It can be used to separate parts of the output. The line style of the
rule can be changed via the the \code{line-type} property. Possible values
are:
}
\details{
\itemize{
\item \code{"single"}: (same as \code{1}), a single line,
\item \code{"double"}: (same as \code{2}), a double line,
\item \code{"bar1"}, \code{"bar2"}, \code{"bar3"}, etc., \code{"bar8"} uses varying height bars.
}

Colors and background colors can similarly changed via a theme, see
examples below.
}
\examples{
cli_rule()
cli_text(packageDescription("cli")$Description)
cli_rule()

# Theming
d <- cli_div(theme = list(rule = list(
  color = "blue",
  "background-color" = "darkgrey",
  "line-type" = "double")))
cli_rule("Left", right = "Right")
cli_end(d)

# Interpolation
cli_rule(left = "One plus one is {1+1}")
cli_rule(left = "Package {.pkg mypackage}")
}
