% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_misspelled_values.R
\name{correct_misspelled_values}
\alias{correct_misspelled_values}
\title{Correct misspelled values by using approximate string matching techniques to
compare them against the expected values.}
\usage{
correct_misspelled_values(
  data,
  target_columns,
  wordlist,
  max_distance = 1,
  confirm = rlang::is_interactive(),
  ...
)
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}}

\item{target_columns}{A \code{<vector>} of the target column names. When the
input data is a \code{<linelist>} object, this parameter can be set to
\code{linelist_tags} to apply the fuzzy matching exclusively to the
tagged columns.}

\item{wordlist}{A \code{<vector>} of characters with the words to match to
the detected misspelled values.}

\item{max_distance}{An \code{<integer>} for the maximum distance allowed for
detecting a spelling mistakes from the \code{wordlist}. The distance is the
generalized Levenshtein edit distance (see \code{\link[=adist]{adist()}}). Default is \code{1}.}

\item{confirm}{A \code{<logical>} that determines whether to show the user a
menu of spelling corrections. If \code{TRUE} and using \R interactively then
the user will have the option to review the proposed spelling corrections.
This argument is useful for turning off the \code{\link[=menu]{menu()}} when
\code{\link[rlang:is_interactive]{rlang::is_interactive()}} returns \code{TRUE} but not wanting to prompt the
user e.g. \code{devtools::run_examples()}.}

\item{...}{\link{dots} Extra arguments to pass to \code{\link[=adist]{adist()}}.}
}
\value{
The corrected input data according to the user-specified \code{wordlist}.
}
\description{
Correct misspelled values by using approximate string matching techniques to
compare them against the expected values.
}
\details{
When used interactively (see \code{\link[=interactive]{interactive()}}) the user is presented a menu
to ensure that the words detected using approximate string matching are not
false positives and the user can decided whether to proceed with the
spelling corrections. In non-interactive sessions all misspelled values are
replaced by their closest values within the provided vector of expected
values.

If multiple words supplied in the \code{wordlist} equally match a word in the
data and \code{confirm} is \code{TRUE} the user is presented a menu to choose the
replacement word. If it is not used interactively multiple equal matches
throws a warning.
}
\examples{
df <- data.frame(
  case_type = c("confirmed", "confermed", "probable", "susspected"),
  outcome = c("died", "recoverd", "did", "recovered")
)
df
correct_misspelled_values(
  data = df,
  target_columns = c("case_type", "outcome"),
  wordlist = c("confirmed", "probable", "suspected", "died", "recovered"),
  confirm = FALSE
)
}
