/*
 * Decompiled with CFR 0.152.
 */
package edu.richmond.nlp;

import edu.richmond.nlp.CSVCoreferenceOutputter;
import edu.richmond.nlp.CSVDependencyOutputter;
import edu.richmond.nlp.CSVDocumentOutputter;
import edu.richmond.nlp.CSVNamedEntityOutputter;
import edu.richmond.nlp.CSVSentimentOutputter;
import edu.richmond.nlp.CSVTokenOutputter;
import edu.richmond.nlp.CSVTripleOutputter;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationProcessor {
    TimeZone tz = TimeZone.getTimeZone("UTC");
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
    String output_path = "";
    String language = "";
    int idOffset = 0;

    public void setOutputPath(String output_path) {
        this.output_path = output_path;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setIdOffset(int idOffset) {
        this.idOffset = idOffset;
    }

    public void processFiles(String[] file_list, StanfordCoreNLP scnlp) throws FileNotFoundException, IOException {
        this.processFiles(Arrays.asList(file_list), scnlp);
    }

    public void processFiles(List<String> file_list, StanfordCoreNLP scnlp) throws FileNotFoundException, IOException {
        String corenlp_version = scnlp.getClass().getPackage().getImplementationVersion();
        this.df.setTimeZone(this.tz);
        boolean append = false;
        int docID = this.idOffset;
        for (int i = 0; i < file_list.size(); ++i) {
            String docIDString = Integer.toString(docID);
            String uri = file_list.get(i);
            String starttime = this.df.format(new Date());
            Annotation annotation = scnlp.process(this.readFileAsString(uri));
            Object output = null;
            AnnotationOutputter.Options opt = new AnnotationOutputter.Options();
            CSVTokenOutputter tokenOut = new CSVTokenOutputter(docIDString, append);
            tokenOut.print(annotation, new FileOutputStream(this.output_path + "token.csv", append), opt);
            CSVDependencyOutputter depOut = new CSVDependencyOutputter(docIDString, append);
            depOut.print(annotation, new FileOutputStream(this.output_path + "dependency.csv", append), opt);
            CSVNamedEntityOutputter entityOut = new CSVNamedEntityOutputter(docIDString, append);
            entityOut.print(annotation, new FileOutputStream(this.output_path + "entity.csv", append), opt);
            CSVTripleOutputter tripleOut = new CSVTripleOutputter(docIDString, append);
            tripleOut.print(annotation, new FileOutputStream(this.output_path + "triple.csv", append), opt);
            CSVCoreferenceOutputter corefOut = new CSVCoreferenceOutputter(docIDString, append);
            corefOut.print(annotation, new FileOutputStream(this.output_path + "coreference.csv", append), opt);
            CSVSentimentOutputter sentimentOut = new CSVSentimentOutputter(docIDString, append);
            sentimentOut.print(annotation, new FileOutputStream(this.output_path + "sentiment.csv", append), opt);
            CSVDocumentOutputter docOut = new CSVDocumentOutputter(docIDString, append, this.language, starttime, uri, corenlp_version);
            docOut.print(annotation, new FileOutputStream(this.output_path + "document.csv", append), opt);
            append = true;
            ++docID;
        }
    }

    public String readFileAsString(String file_name) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        String s = "";
        File file = new File(file_name);
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        s = new String(data, "UTF-8");
        return s;
    }
}

