% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDistMat.R
\name{parallelComputeDistMat}
\alias{parallelComputeDistMat}
\title{Paralleize computing a distance matrix for functional observations}
\usage{
parallelComputeDistMat(x, y = NULL, method = "Euclidean", batches = 1L,
  ...)
}
\arguments{
\item{x}{[\code{matrix}]\cr
matrix containing the functional observations as rows.}

\item{y}{[\code{matrix}]\cr
see \code{x}. The default \code{NULL} uses \code{y = x}.}

\item{method}{[\code{character(1)}]\cr
 character string describing the distance function to be used. For a full list
 execute \code{\link{metricChoices}()}.
\describe{
 \item{\code{Euclidean}}{equals \code{Lp} with \code{p = 2}. This is the default.}
 \item{\code{Lp, Minkowski}}{the distance for an Lp-space, takes \code{p} as
 an additional argument in \code{...}.}
 \item{\code{Manhattan}}{equals \code{Lp} with \code{p = 1}.}
 \item{\code{supremum, max, maximum}}{equals \code{Lp} with \code{p = Inf}.
 The supremal pointwise difference between the curves.}
 \item{\code{and ...}}{all other available measures for \code{\link[proxy]{dist}}.}
 \item{\code{shortEuclidean}}{Euclidean distance on a limited part of the domain.
 Additional arguments \code{dmin} and \code{dmax} can be specified in
 \code{...}, giving
 the position of the first and the last point to use of an evenly spaced
 sequence from \code{0} to \code{1} of length \code{length(grid)}.
 The default values are \code{dmin = o} and \code{dmax = 1},
 which results in the Euclidean distance on the entire domain.}
 \item{\code{mean}}{the absolute similarity of the overall mean values of
 the observations.}
 \item{\code{relAreas}}{the difference of the relation of two areas on parts
 of the domain given by \code{dmin1} to \code{dmax1} and \code{dmin2} to
 \code{dmax2}. They are defined analogously to \code{dmin} and \code{dmax}
 and take the same default values.}
 \item{\code{jump}}{the similarity of jump heights at points \code{t1} and \code{t2},
 i.e. \code{x[t1 * length(x)] - x[t2 * length(x)]} for every functional observation \code{x}.
 The points \code{t1} and \code{t2} are the positions  in an evenly spaced sequence
 from \code{0} to \code{1} of length \code{length(grid)} for which to compare the
 jump height. The default values are \code{t1 = 0} and \code{t2 = 1}.}
 \item{\code{globMax}}{the difference of the curves global maxima.}
 \item{\code{globMin}}{the difference of the curves global minima.}
 \item{\code{points}}{the mean absolute differences at certain observation
 points \code{.poi}, also  called "points of impact". These are specified as
 a vector \code{.poi} of arbitrary length with values between \code{0}
 and \code{1}, encoding the the index of the points of observations.
 The default value is \code{.poi = seq(0, 1, length.out = length(grid))}, which results in the Manhattan
 distance.}
 \item{\code{custom.metric}}{your own semimetric will be used. Specify your
 own distance function in the argument \code{custom.metric}.}
 \item{\code{amplitudeDistance,phaseDistance}}{The amplitude distance or
 phase distance as described in
 Srivastava, A. and E. P. Klassen (2016). Functional and Shape Data Analysis. Springer.
 }
 \item{\code{FisherRao, elasticMetric}}{the elastic distance of the square
 root velocity of the curves as described in Srivastava and Klassen (2016).
 This equates to the Fisher Rao metric.}
 \item{\code{elasticDistance}}{weighted mean of the amplitude and the phase
 distance using the implementation in \code{\link[fdasrvf]{elastic.distance}}.
 Additional arguments are the numeric the penalization parameters \code{a,b,c}
 for the amplitude distance (\code{a^2}) and the phase distance (\code{b^2}).
 The default values are \code{a = 1/2, b = 1}.
 Alternatively \code{c} denotes the ratio of \code{2*a} and \code{b}.
 \code{lambda} is the additional penalization parameter for the warping
 allowed before calculating the elastic distance. The default is 1.}
\item{\code{rucrdtw, rucred}}{Dynamic Time Warping Distance and Euclidean Distance
 from package \code{\link{rucrdtw}}. Implemented in Boersch-Supan (2016) and
 originally described in Rakthanmanon et al. (2012).}
 }}

\item{batches}{[\code{integer(1)}]\cr
Number of roughly equal-sized batches to split data into. The distance computation is then carried out
for each batch.}

\item{...}{additional parameters to the (semi-)metrics.}
}
\value{
a matrix of dimensions \code{nrow(x)} by \code{nrow(y)} containing the
  distances of the functional observations contained in \code{x} and \code{y},
  if \code{y} is specified. Otherwise a matrix containing the distances of all
  functional observations within \code{x} to each other.
}
\description{
Uses \code{\link[parallelMap]{parallelMap}} to parallelize the computation of the distance
  matrix. This is done by dividing the data into batches and computing
  the distance matrix for each batch.
  For details on distance computation see \code{\link{computeDistMat}}.
}
