% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_list.R
\name{package_list}
\alias{package_list}
\title{List datasets.}
\usage{
package_list(
  offset = 0,
  limit = 31,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{offset}{(numeric) Where to start getting activity items from (optional, default: 0)}

\item{limit}{(numeric) The maximum number of activities to return (optional, default: 31)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
List datasets.
}
\examples{
\dontrun{
package_list()
package_list(as = 'json')
package_list(as = 'table')

package_list(url = 'http://data.nhm.ac.uk')
}
}
